<?php

/*
Plugin Name: Gfxbucket Shortcodes
Description: A collection of shortcodes and Page Builder widgets.
Version: 1.1.0
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
License: GPL3
License URI: https://www.gnu.org/licenses/gpl-3.0.txt
*/

require 'plugin-update-checker/plugin-update-checker.php';
$myUpdateChecker = PucFactory::buildUpdateChecker(
    'http://zmthemes.com/dropout-wp-extra/gfxbucket-shortcodes.json',
    __FILE__
);

function gfxbucket_shortcodes_init( $folders ) {
	load_plugin_textdomain( 'gfxbucket-shortcodes', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

	/* Add Shortcodes */
	$shortcodes = array('video', 'gallery', 'section_fs', 'paragraph', 'link', 'blog', 'twitter', 'portfolio_featured', 'tab', 'portfolio','accordion', 'testimonials', 'break', 'google_maps', 'icon', 'member', 'button', 'title', 'pricing_table', 'recent_posts', 'instagram', 'progress_bar', 'clients', 'counter', 'image', 'more', 'section_title', 'team');

	foreach ($shortcodes as $shortcode) {
		include( plugin_dir_path( __FILE__ ) . 'shortcodes/' . $shortcode . '.php');
	}

	/* Add Shortcodes to TinyMCE */
	if ( is_admin() ) { 
		require_once plugin_dir_path( __FILE__ )  . 'admin/admin.php';
	}

	/* Check if Page Builder and SiteOrigin Bundle are active */
	if( class_exists('SiteOrigin_Panels_Widgets_Layout') && class_exists('SiteOrigin_Widgets_Bundle') ) {
		add_filter( 'siteorigin_panels_widgets', 'gfxbucket_panels_widgets', 11 );
		add_filter( 'siteorigin_panels_widget_dialog_tabs', 'gfxbucket_add_widget_tabs', 99 );

		/*add_theme_support( 'siteorigin-panels', array(
			'margin' => 100,
		));*/

		/* Add Gfxbucket Page Builder Widgets */
		$widgets = array('video', 'visual_editor', 'gallery', 'section_fs', 'blog', 'twitter', 'portfolio', 'portfolio_featured', 'testimonials', 'accordion', 'tab', 'button', 'title', 'member', 'recent_posts', 'instagram', 'more', 'counter', 'team', 'progress_bar_two_column', 'progress_bar', 'clients', 'pricing_table', 'icon', 'contact_form_7', 'google_maps');
		foreach ($widgets as $widget) {
			include( plugin_dir_path( __FILE__ ) . 'widgets/' . str_replace('_', '-', $widget) . '/' . $widget . '.php' );
		}
	}

	add_filter('siteorigin_panels_row_style_attributes', 'gfxbucket_custom_row_style_attributes', 10, 2);

	/*if( is_admin() ) {
		add_filter( 'siteorigin_widgets_icon_families', 'gfxbucket_widgets_icon_families_filter' );
	}*/
}
add_filter('plugins_loaded', 'gfxbucket_shortcodes_init', 99);

function gfxbucket_the_content_filter($content) {

	// array of custom shortcodes requiring the fix 
	$block = join("|", array('gfxbucket_gallery', 'gfxbucket_gallery_item', 'portfolio_featured', 'portfolio_featured_item', 'accordion', 'accordion_item', 'tab', 'pricing_table', 'pricing_table_row', 'title', 'testimonials', 'button', 'section', 'clients', 'client', 'counter', 'counter_item', 'image', 'more', 'section_title'));

	// opening tag
	$rep = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/", "[$2$3]", $content);
		
	// closing tag
	$rep = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)?/","[/$2]", $rep);

	return $rep;

}
add_filter("the_content", "gfxbucket_the_content_filter");

/* Remove Default Widgets */

function gfxbucket_panels_widgets( $widgets ) {
	/*unset($widgets['SiteOrigin_Widget_Slider_Widget']);
	unset($widgets['SiteOrigin_Widget_PostCarousel_Widget']);
	unset($widgets['SiteOrigin_Widget_Features_Widget']);
	unset($widgets['SiteOrigin_Widget_Image_Widget']);
	unset($widgets['SiteOrigin_Widget_Button_Widget']);*/

	return $widgets;
}

/* Add Widgets Tab */

function gfxbucket_add_widget_tabs($tabs) {

	/* Add Gfxbucket Widgets Tab */
    array_unshift($tabs, array(
        'title' => __('Gfxbucket Widgets', 'gfxbucket-shortcodes'),
        'filter' => array(
            'groups' => array('gfxbucket-widgets')
        )
    ));

    return $tabs;
}

function gfxbucket_change_class($classes) {
	return array();
}
add_filter('siteorigin_panels_widget_classes', 'gfxbucket_change_class');

/* Add Prebuilt Layouts */

function gfxbucket_prebuilt_layouts($layouts){
    $layouts['contact-page'] = array(
        'name' => __('Contact Page', 'gfxbucket-shortcodes'),
        'description' => __('Page with Google Maps and Contact Form 7 form.', 'gfxbucket-shortcodes'),
		  'widgets' => 
		  array (
		    0 => 
		    array (
		      'location' => '215. W Avenue 26',
		      'zoom' => 14,
		      'panels_info' => 
		      array (
		        'class' => 'Gfxbucket_Google_Maps',
		        'raw' => false,
		        'grid' => 0,
		        'cell' => 0,
		        'id' => 0,
		        'style' => 
		        array (
		          'background_display' => 'tile',
		        ),
		      ),
		    ),
		    1 => 
		    array (
		      'text' => 'We’re currently acceping new projects.[break]We’d love to hear form you',
		      'style' => 'style-2',
		      'size' => 'h3',
		      'panels_info' => 
		      array (
		        'class' => 'Gfxbucket_Title',
		        'raw' => false,
		        'grid' => 1,
		        'cell' => 0,
		        'id' => 1,
		        'style' => 
		        array (
		          'background_display' => 'tile',
		        ),
		      ),
		    ),
		    2 => 
		    array (
		      'contact_form' => '1',
		      'panels_info' => 
		      array (
		        'class' => 'Gfxbucket_Contact_Form_7',
		        'raw' => false,
		        'grid' => 2,
		        'cell' => 1,
		        'id' => 2,
		        'style' => 
		        array (
		          'background_display' => 'tile',
		        ),
		      ),
		    ),
		  ),
		  'grids' => 
		  array (
		    0 => 
		    array (
		      'cells' => 1,
		      'style' => 
		      array (
		        'text_align' => 'left',
		        'row_stretch' => 'full-stretched',
		        'background_display' => 'tile',
		      ),
		    ),
		    1 => 
		    array (
		      'cells' => 1,
		      'style' => 
		      array (
		        'text_align' => 'center',
		        'bottom_margin' => '0px',
		        'background_display' => 'tile',
		      ),
		    ),
		    2 => 
		    array (
		      'cells' => 3,
		      'style' => 
		      array (
		        'text_align' => 'left',
		        'background_display' => 'tile',
		      ),
		    ),
		  ),
		  'grid_cells' => 
		  array (
		    0 => 
		    array (
		      'grid' => 0,
		      'weight' => 1,
		    ),
		    1 => 
		    array (
		      'grid' => 1,
		      'weight' => 1,
		    ),
		    2 => 
		    array (
		      'grid' => 2,
		      'weight' => 0.1665000000000000091038288019262836314737796783447265625,
		    ),
		    3 => 
		    array (
		      'grid' => 2,
		      'weight' => 0.6670000000000000373034936274052597582340240478515625,
		    ),
		    4 => 
		    array (
		      'grid' => 2,
		      'weight' => 0.1665000000000000091038288019262836314737796783447265625,
		    ),
		  ),
    );

	$layouts['about-page'] = array(
        'name' => __('About Page', 'gfxbucket-shortcodes'),
        'description' => __('Page with team members and clients.', 'gfxbucket-shortcodes'),
        'widgets' => 
  array (
    0 => 
    array (
      'text' => 'We are a team of entrepreneurs,[break]who love to work on unique projects',
      'style' => 'style-2',
      'size' => 'h3',
      'panels_info' => 
      array (
        'class' => 'Gfxbucket_Title',
        'raw' => false,
        'grid' => 0,
        'cell' => 0,
        'id' => 0,
        'style' => 
        array (
          'background_display' => 'tile',
        ),
      ),
    ),
    1 => 
    array (
      'team_member' => 
      array (
        0 => 
        array (
          'name' => 'John Doe',
          'title' => 'Founder',
          'image_fallback' => 'http://www.zmthemes.com/dropout-wp-extra/dummy/team-placeholder.gif',
          'image' => 0,
          'social' => 
          array (
            0 => 
            array (
              'icon' => 'fontawesome-facebook',
              'url' => '#',
            ),
            1 => 
            array (
              'icon' => 'fontawesome-twitter',
              'url' => '#',
            ),
            2 => 
            array (
              'icon' => 'fontawesome-dribbble',
              'url' => '#',
            ),
            3 => 
            array (
              'icon' => 'fontawesome-instagram',
              'url' => '#',
            ),
          ),
        ),
        1 => 
        array (
          'name' => 'Martha Jones',
          'title' => 'Web Designer',
          'image_fallback' => 'http://www.zmthemes.com/dropout-wp-extra/dummy/team-placeholder.gif',
          'image' => 0,
          'social' => 
          array (
            0 => 
            array (
              'icon' => 'fontawesome-facebook',
              'url' => '#',
            ),
            1 => 
            array (
              'icon' => 'fontawesome-twitter',
              'url' => '#',
            ),
            2 => 
            array (
              'icon' => 'fontawesome-dribbble',
              'url' => '#',
            ),
            3 => 
            array (
              'icon' => 'fontawesome-instagram',
              'url' => '#',
            ),
          ),
        ),
        2 => 
        array (
          'name' => 'Andy Timmons',
          'title' => 'Web Developer',
          'image_fallback' => 'http://www.zmthemes.com/dropout-wp-extra/dummy/team-placeholder.gif',
          'image' => 0,
          'social' => 
          array (
            0 => 
            array (
              'icon' => 'fontawesome-facebook',
              'url' => '#',
            ),
            1 => 
            array (
              'icon' => 'fontawesome-twitter',
              'url' => '#',
            ),
            2 => 
            array (
              'icon' => 'fontawesome-dribbble',
              'url' => '#',
            ),
            3 => 
            array (
              'icon' => 'fontawesome-instagram',
              'url' => '#',
            ),
          ),
        ),
      ),
      'panels_info' => 
      array (
        'class' => 'Gfxbucket_Team',
        'grid' => 0,
        'cell' => 0,
        'id' => 1,
        'style' => 
        array (
          'background_image_attachment' => false,
          'background_display' => 'tile',
        ),
      ),
    ),
    2 => 
    array (
      'text' => 'Clients[break]We have',
      'style' => 'style-1',
      'size' => 'h2',
      'panels_info' => 
      array (
        'class' => 'Gfxbucket_Title',
        'raw' => false,
        'grid' => 1,
        'cell' => 0,
        'id' => 2,
        'style' => 
        array (
          'background_display' => 'tile',
        ),
      ),
    ),
    3 => 
    array (
      'client' => 
      array (
        0 => 
        array (
          'name' => 'Lorem',
          'image_fallback' => 'http://zmthemes.com/dropout-wp/wp-content/uploads/2015/03/client-1.png',
          'image' => 0,
          'url' => '#',
          'new_window' => false,
        ),
        1 => 
        array (
          'name' => 'Ipsum',
          'image_fallback' => 'http://zmthemes.com/dropout-wp/wp-content/uploads/2015/03/client-2.png',
          'image' => 0,
          'url' => '#',
          'new_window' => false,
        ),
        2 => 
        array (
          'name' => 'Dolor',
          'image_fallback' => 'http://zmthemes.com/dropout-wp/wp-content/uploads/2015/03/client-3.png',
          'image' => 0,
          'url' => '#',
          'new_window' => false,
        ),
        3 => 
        array (
          'name' => 'Ametex',
          'image_fallback' => 'http://zmthemes.com/dropout-wp/wp-content/uploads/2015/03/client-4.png',
          'image' => 0,
          'url' => '#',
          'new_window' => false,
        ),
        4 => 
        array (
          'name' => 'Conse',
          'image_fallback' => 'http://zmthemes.com/dropout-wp/wp-content/uploads/2015/03/client-5.png',
          'image' => 0,
          'url' => '#',
          'new_window' => false,
        ),
        5 => 
        array (
          'name' => 'Vitae',
          'image_fallback' => 'http://zmthemes.com/dropout-wp/wp-content/uploads/2015/03/client-6.png',
          'image' => 0,
          'url' => '#',
          'new_window' => false,
        ),
      ),
      'panels_info' => 
      array (
        'class' => 'Gfxbucket_Clients',
        'raw' => false,
        'grid' => 1,
        'cell' => 1,
        'id' => 3,
        'style' => 
        array (
          'background_display' => 'tile',
        ),
      ),
    ),
  ),
  'grids' => 
  array (
    0 => 
    array (
      'cells' => 1,
      'style' => 
      array (
        'text_align' => 'center',
        'bottom_margin' => '120px',
        'row_stretch' => 'full-stretched',
        'background_display' => 'tile',
      ),
    ),
    1 => 
    array (
      'cells' => 2,
      'style' => 
      array (
      ),
    ),
  ),
  'grid_cells' => 
  array (
    0 => 
    array (
      'grid' => 0,
      'weight' => 1,
    ),
    1 => 
    array (
      'grid' => 1,
      'weight' => 0.25,
    ),
    2 => 
    array (
      'grid' => 1,
      'weight' => 0.75,
    ),
  ),
    );

  $layouts['section-fs'] = array(
        'name' => __('Section Scrolling', 'gfxbucket-shortcodes'),
        'description' => __('Displays full screen sections with background images. Uses section scrolling (dots on the right side). Turn off footer spacing to remove scrollbar.', 'gfxbucket-shortcodes'),
  'widgets' => 
  array (
    0 => 
    array (
      'navigation' => true,
      'section_items' => 
      array (
        0 => 
        array (
          'form_type' => 'simple',
          'tooltip' => '',
          'slug' => '',
          'instagram' => 
          array (
            'instagram_id' => '',
          ),
          'twitter' => 
          array (
            'instagram_username' => '',
          ),
          'contact' => 
          array (
            'title' => '',
            'contact_id' => '',
            'image' => 0,
            'image_fallback' => '',
            'animate' => false,
          ),
          'simple' => 
          array (
            'image' => 0,
            'image_fallback' => 'http://www.zmthemes.com/dropout-wp-dc/assets/background.gif',
            'title' => 'Planets come[break]Stars perish',
            'text' => 'Planets come and go. Stars perish. Matter disperses, coalesces, forms into other patterns, other worlds.',
            'link' => '#',
            'link_text' => 'Find Out More',
            'align' => 'left',
            'animate' => false,
            'new_window' => false,
          ),
          'advanced' => 
          array (
            'content' => '',
            'image' => 0,
            'image_fallback' => '',
            'box_align_x' => 'left',
            'box_align_y' => 'center',
            'align' => 'left',
            'animate' => false,
          ),
        ),
        1 => 
        array (
          'form_type' => 'simple',
          'tooltip' => '',
          'slug' => '',
          'instagram' => 
          array (
            'instagram_id' => '',
          ),
          'twitter' => 
          array (
            'instagram_username' => '',
          ),
          'contact' => 
          array (
            'title' => '',
            'contact_id' => '',
            'image' => 0,
            'image_fallback' => '',
            'animate' => false,
          ),
          'simple' => 
          array (
            'image' => 0,
            'image_fallback' => 'http://www.zmthemes.com/dropout-wp-dc/assets/background.gif',
            'title' => 'Matter disperses, [break]coalesces, forms',
            'text' => 'Planets come and go. Stars perish. Matter disperses, coalesces, forms into other patterns, other worlds. Nothing can be eternal.',
            'link' => '#',
            'link_text' => 'Find Out More',
            'align' => 'center',
            'animate' => false,
            'new_window' => false,
          ),
          'advanced' => 
          array (
            'content' => '',
            'image' => 0,
            'image_fallback' => '',
            'box_align_x' => 'left',
            'box_align_y' => 'center',
            'align' => 'left',
            'animate' => false,
          ),
        ),
        2 => 
        array (
          'form_type' => 'simple',
          'tooltip' => '',
          'slug' => '',
          'instagram' => 
          array (
            'instagram_id' => '',
          ),
          'twitter' => 
          array (
            'instagram_username' => '',
          ),
          'contact' => 
          array (
            'title' => '',
            'contact_id' => '',
            'image' => 0,
            'image_fallback' => '',
            'animate' => false,
          ),
          'simple' => 
          array (
            'image' => 0,
            'image_fallback' => 'http://www.zmthemes.com/dropout-wp-dc/assets/background.gif',
            'title' => 'Nothing can be eternal',
            'text' => 'Planets come and go. Stars perish. Matter disperses, coalesces, forms into other patterns, other worlds. Nothing can be eternal.',
            'link' => '#',
            'link_text' => 'Find Out More',
            'align' => 'center',
            'animate' => false,
            'new_window' => false,
          ),
          'advanced' => 
          array (
            'content' => '',
            'image' => 0,
            'image_fallback' => '',
            'box_align_x' => 'left',
            'box_align_y' => 'center',
            'align' => 'left',
            'animate' => false,
          ),
        ),
        3 => 
        array (
          'form_type' => 'simple',
          'tooltip' => '',
          'slug' => '',
          'instagram' => 
          array (
            'instagram_id' => '',
          ),
          'twitter' => 
          array (
            'instagram_username' => '',
          ),
          'contact' => 
          array (
            'title' => '',
            'contact_id' => '',
            'image' => 0,
            'image_fallback' => '',
            'animate' => false,
          ),
          'simple' => 
          array (
            'image' => 0,
            'image_fallback' => 'http://www.zmthemes.com/dropout-wp-dc/assets/background.gif',
            'title' => 'I was being chased by a giant dinosaur',
            'text' => 'Planets come and go. Stars perish. Matter disperses, coalesces, forms into other patterns, other worlds.',
            'link' => '#',
            'link_text' => 'Find Out More',
            'align' => 'right',
            'animate' => false,
            'new_window' => false,
          ),
          'advanced' => 
          array (
            'content' => '',
            'image' => 0,
            'image_fallback' => '',
            'box_align_x' => 'left',
            'box_align_y' => 'center',
            'align' => 'left',
            'animate' => false,
          ),
        ),
      ),
      'panels_info' => 
      array (
        'class' => 'Gfxbucket_Section_Fs',
        'grid' => 0,
        'cell' => 0,
        'id' => 0,
        'style' => 
        array (
          'background_image_attachment' => false,
          'background_display' => 'tile',
        ),
      ),
      'scrollbar' => false,
    ),
  ),
  'grids' => 
  array (
    0 => 
    array (
      'cells' => 1,
      'style' => 
      array (
        'parallax' => '',
        'text_align' => 'left',
        'row_stretch' => 'full-stretched',
        'background_display' => 'tile',
      ),
    ),
  ),
  'grid_cells' => 
  array (
    0 => 
    array (
      'grid' => 0,
      'weight' => 1,
    ),
  ),
);

    return $layouts;

}
add_filter('siteorigin_panels_prebuilt_layouts', 'gfxbucket_prebuilt_layouts');


/* Add Custom Row Options */

function gfxbucket_custom_row_style_fields($fields) {
	$fields['parallax'] = array(
		'name'        => __('Parallax', 'gfxbucket-shortcodes'),
		'type'        => 'checkbox',
		'group'       => 'design',
		'description' => __('If enabled, the background image will have a parallax effect.', 'gfxbucket-shortcodes'),
		'priority'    => 8,
	);

	$fields['text_align'] = array(
		'name'        => __('Text Align', 'gfxbucket-shortcodes'),
		'type'        => 'select',
		'options' => array(
			'left'   => __('Left', 'gfxbucket-shortcodes'),
			'right'  => __('Right', 'gfxbucket-shortcodes'),
			'center' => __('Center', 'gfxbucket-shortcodes'),
		),
		'group'       => 'layout',
		'description' => __('Text align.', 'gfxbucket-shortcodes'),
		'priority'    => 11,
	);

	$media_query = new WP_Query(
	    array(
	        'post_type' => 'attachment',
	        'post_status' => 'inherit',
	        'post_mime_type' =>'video',
	        'posts_per_page' => -1,
	    )
	);

	$videos = array( '' => '' );

	foreach ($media_query->posts as $video) {
	    $videos[wp_get_attachment_url($video->ID)] = $video->post_title;
	}

  $fields['background_video_external'] = array(
    'name' => __('Background Video External URL', 'gfxbucket-shortcodes'),
    'type' => 'text',
    'group' => 'design',
    'options' => $videos,
    'description' => __('URL for the background video of the row. Useful if the video is not added using the Media library.', 'gfxbucket-shortcodes'),
    'priority' => 6,
  );

  $fields['background_video'] = array(
    'name' => __('Background Video', 'gfxbucket-shortcodes'),
    'type' => 'select',
    'group' => 'design',
    'options' => $videos,
    'description' => __('Background video of the row.', 'gfxbucket-shortcodes'),
    'priority' => 6,
  );

	return $fields;
}
add_filter( 'siteorigin_panels_row_style_fields', 'gfxbucket_custom_row_style_fields' );

function gfxbucket_custom_row_style_attributes( $attributes, $args ) {
	if( !empty( $args['parallax'] ) ) {
		array_push($attributes['class'], 'parallax');
	}

	if( strpos($attributes['style'], 'background-image') > -1 ) {
		array_push($attributes['class'], 'statement');
	}

	if( !empty( $args['text_align'] ) ) {
		if( $args['text_align'] == 'center' ) {
			array_push($attributes['class'], 'text-center');
		} else if ( $args['text_align'] == 'right' ) {
			array_push($attributes['class'], 'text-right');
		}
	}

	if( !empty( $args['background_video'] ) ) {
		array_push($attributes['class'], 'statement');
		array_push($attributes['class'], 'video');

		$attributes['data-background-video'] = $args['background_video'];
	}

  if( !empty( $args['background_video_external'] ) ) {
    array_push($attributes['class'], 'statement');
    array_push($attributes['class'], 'video');

    $attributes['data-background-video-external'] = $args['background_video_external'];
  }

	return $attributes;
}