<?php

function gfxbucket_counter_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'animate' => 'yes',
		'no_image' => 'yes',
	), $atts ));

	$class = '';

	if( $animate == 'yes' || $animate == '1' ) {
		$class .= ' animate';
	}

	if( $no_image == 'yes' ) {
		$class .= ' counter-no-image';
	}

	global $num_counter_items;
	$num_counters = 0;

	$content = do_shortcode($content);

	return '<ul class="counter counter-col-' . $num_counter_items . $class . '">' . $content . '</ul>';
}
add_shortcode( 'counter', 'gfxbucket_counter_func' );

function gfxbucket_counter_item_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'number' => '0',
        'title'  => '',
        'image' => '',
        'icon'  => '',
	), $atts ));

	global $num_counter_items;
	$num_counter_items++;

	$counter_image = '';

	$icon = str_replace('fontawesome', 'fa', $icon);
	$icon = str_replace('typicons', 'typcn', $icon);
	$icon = str_replace('genericons', 'genericon', $icon);

	if( $image ) {
		$counter_image = '<img src="' . $image . '" alt="">';
	}	
	else if( $icon ) {
		if ( strpos($icon, 'fa') > -1 ) {
			$counter_image = '<i class="fa ' . $icon . '"></i>';
		} else if ( strpos($icon, 'typcn') > -1 ) {
			$counter_image = '<i class="typcn ' . $icon . '"></i>';
			wp_enqueue_style( 'gfxbucket-typicons', plugins_url( 'css/min/typicons.min.css', __FILE__ ) );
		} else if ( strpos($icon, 'elegantline') > -1 ) {
			$counter_image = '<i class="elegantline ' . $icon . '"></i>';
			wp_enqueue_style( 'gfxbucket-elegantline', plugins_url( 'css/min/elegantline.min.css', __FILE__ ) );
		} else if ( strpos($icon, 'genericon') > -1 ) {
			$counter_image = '<i class="genericon ' . $icon . '"></i>';
			wp_enqueue_style( 'gfxbucket-genericons', plugins_url( 'css/min/genericons.min.css', __FILE__ ) );
		} else if ( strpos($icon, 'icomoon') > -1 ) {
			$counter_image = '<i class="icomoon ' . $icon . '"></i>';
			wp_enqueue_style( 'gfxbucket-icomoon', plugins_url( 'css/min/icomoon.min.css', __FILE__ ) );
		}
	}

	return '<li><div class="counter-image">' . $counter_image . '</div><span data-val="' . $number . '">' . $number . '</span><div>' . $title . '</div></li>';
}
add_shortcode( 'counter_item', 'gfxbucket_counter_item_func' );