<?php

global $gfxbucket_gallery_id;
$gfxbucket_gallery_id = 0;

function gfxbucket_gallery_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'columns'=> '4',
		'size'   => 'default'
	), $atts ));

	global $gfxbucket_gallery_id, $gfxbucket_columns, $gfxbucket_gallery_size;

	$gfxbucket_gallery_size = $size;

	$gfxbucket_columns = $columns;
	$gfxbucket_gallery_id++;

	return '<div id="gfxbucket-gallery-' . $gfxbucket_gallery_id . '" class="gallery gallery-columns-' . $columns . '">' . do_shortcode($content) . '</div>';
}
add_shortcode( 'gfxbucket_gallery', 'gfxbucket_gallery_func' );

function gfxbucket_gallery_item_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'caption' => '',
        'large'   => '',
        'thumb'   => '',
        'image'   => ''
	), $atts ));

	global $gfxbucket_columns, $gfxbucket_gallery_size;

	if( $image != '' && is_numeric($image) ) {
		$large = wp_get_attachment_image_src($image, 'full');

		if( $gfxbucket_gallery_size != 'default' ) {
			$thumb = wp_get_attachment_image_src($image, $gfxbucket_gallery_size);
		} else if( $gfxbucket_columns >= 3 ) {
			$thumb = wp_get_attachment_image_src($image, 'portfolio-4-columns');
		} else {
			$thumb = $large;
		}

		$large = $large[0];
		$thumb = $thumb[0];
	} else {
		$large = $image;
		$thumb = $image;
	}

	if( $caption != '' ) {
		$caption = '<figcaption class="gallery-caption">' . $caption . '</figcaption>';
	}

	return '<figure class="gallery-item">
				<a href="' . $large . '"><img src="' . $thumb . '"></a>
				' . $caption . '
			</figure>';
}
add_shortcode( 'gfxbucket_gallery_item', 'gfxbucket_gallery_item_func' );