<?php

/*
Widget Name: Blog widget
Description: A customizable blog widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Blog extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-blog',
			__('Gfxbucket Blog', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays posts the same way as the Posts page. Allows filtering by categories.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-pencil'
			),
			array(),
			array(
				'per_page' => array(
					'type'    => 'number',
					'label'   => __( 'Post per page', 'gfxbucket-shortcodes' ),
					'default' => 5
				),
				'categories' => array(
					'type' => 'text',
					'label' => __( 'Categories', 'gfxbucket-shortcodes' ),
					'default' => ''
				),
				'type' => array(
					'type' => 'select',
					'label' => __( 'Blog Type', 'gfxbucket-shortcodes' ),
					'default' => 'default',
					'options' => array(
						'default' => __( 'Default', 'gfxbucket-shortcodes' ),
						'masonry-3-columns' => __( 'Masonry 3 columns', 'gfxbucket-shortcodes' ),
						'masonry-4-columns' => __( 'Masonry 4 columns', 'gfxbucket-shortcodes' ),
					)
				),
				'pagination' => array(
					'type' => 'select',
					'label' => __( 'Pagination Type', 'gfxbucket-shortcodes' ),
					'default' => 'default',
					'options' => array(
						'default' => __( 'Default', 'gfxbucket-shortcodes' ),
						'ajax' => __( 'Ajax', 'gfxbucket-shortcodes' ),
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-blog', __FILE__, 'Gfxbucket_Blog');