<?php

/*
Widget Name: Button widget
Description: A customizable button widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Button extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-button',
			__('Gfxbucket Button', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays a button element that can contain a link.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-square-o'
			),
			array(),
			array(
				'button_text' => array(
					'type' => 'text',
					'label' => __( 'Button Text', 'gfxbucket-shortcodes' ),
					'default' => 'Button Text'
				),
				'button_url' => array(
					'type' => 'text',
					'label' => __( 'Destination URL', 'gfxbucket-shortcodes' ),
					'default' => '#'
				),
				'button_new_window' => array(
					'type' => 'checkbox',
					'label' => __( 'Open in a new window', 'gfxbucket-shortcodes' ),
					'default' => false
				),
				'button_size' => array(
					'type' => 'select',
					'label' => __( 'Button Size', 'gfxbucket-shortcodes' ),
					'default' => 'md',
					'options' => array(
						'sm' => __( 'Small', 'gfxbucket-shortcodes' ),
						'md' => __( 'Medium', 'gfxbucket-shortcodes' ),
						'lg' => __( 'Large', 'gfxbucket-shortcodes' ),
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'button-template';
	}

	function get_style_name($instance) {
		return 'button-style';
	}
}

siteorigin_widget_register('gfxbucket-button', __FILE__, 'Gfxbucket_Button');