<?php

/*
Widget Name: Gallery widget
Description: Gallery widgets based on the WordPress Gallery shortcode/element.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Gallery extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-gallery',
			__('Gfxbucket Gallery', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays thumbnails images in a set number of columns and uses a lightbox to show full versions of the images. Based on the default WordPress gallery element.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-photo'
			),
			array(),
			array(
				'columns' => array(
					'type' => 'select',
					'label' => __( 'Columns', 'gfxbucket-shortcodes' ),
					'default' => '4',
					'options' => array(
						'2' => '2',
						'3' => '3',
						'4' => '4',
						'5' => '5',
						'6' => '6',
					)
				),
				'size' => array(
					'type' => 'select',
					'label' => __( 'Thumbnail image size', 'gfxbucket-shortcodes' ),
					'default' => 'default',
					'options' => array(
						'default' => __( 'Default', 'gfxbucket-shortcodes' ),
						'medium'  => __( 'Medium', 'gfxbucket-shortcodes' ),
						'large'   => __( 'Large', 'gfxbucket-shortcodes' ),
						'full'    => __( 'Original', 'gfxbucket-shortcodes' ),
					)
				),
				'gallery_item' => array(
					'type' => 'repeater',
					'label' => __( 'Gallery Item' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'Gallery Item', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='gfxbucket_gallery_item']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(
						'image' => array(
							'type' => 'media',
							'label' => __( 'Gallery Image', 'gfxbucket-shortcodes' ),
							'choose' => __( 'Choose image', 'gfxbucket-shortcodes' ),
							'update' => __( 'Set image', 'gfxbucket-shortcodes' ),
							'library' => 'image',
							'fallback' => true,
						),
						'caption' => array(
							'type' => 'textarea',
							'label' => __( 'Caption', 'gfxbucket-shortcodes' )
						),
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-gallery', __FILE__, 'Gfxbucket_Gallery');