<?php

/*
Widget Name: Portfolio widget
Description: A customizable portfolio widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Portfolio extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-portfolio',
			__('Gfxbucket Portfolio', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays portfolio posts with different layout styles option. Can be filtered by categories.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-camera'
			),
			array(),
			array(
				'type' => array(
					'type' => 'select',
					'label' => __( 'Portfolio Type', 'gfxbucket-shortcodes' ),
					'default' => 'masonry',
					'options' => array(
						'masonry' => __( 'Masonry', 'gfxbucket-shortcodes' ),
						'masonry-style-2' => __( 'Masonry style 2', 'gfxbucket-shortcodes' ),
						'masonry-style-3' => __( 'Masonry style 3', 'gfxbucket-shortcodes' ),
						'masonry-spacing' => __( 'Masonry with spacing', 'gfxbucket-shortcodes' ),
						'4-columns' => __( '4 columns', 'gfxbucket-shortcodes' ),
					)
				),
				'hover_style' => array(
					'type' => 'select',
					'label' => __( 'Hover Style', 'gfxbucket-shortcodes' ),
					'default' => '',
					'options' => array(
						'' => __( 'Style 1', 'gfxbucket-shortcodes' ),
						'style-2' => __( 'Style 2', 'gfxbucket-shortcodes' ),
					)
				),
				'open_style' => array(
					'type' => 'select',
					'label' => __( 'Open single posts', 'gfxbucket-shortcodes' ),
					'default' => '',
					'options' => array(
						'separate' => __( 'in a separate page', 'gfxbucket-shortcodes' ),
						'ajax' => __( 'on top of the current page using AJAX', 'gfxbucket-shortcodes' ),
						'image' => __( 'as the featured image (lightbox)', 'gfxbucket-shortcodes' ),
					)
				),
				'categories' => array(
					'type' => 'text',
					'label' => __( 'Categories', 'gfxbucket-shortcodes' ),
					'default' => ''
				),
				'orderby' => array(
					'type' => 'select',
					'label' => __( 'Order by', 'gfxbucket-shortcodes' ),
					'default' => '',
					'options' => array(
						'date'   => __( 'date', 'gfxbucket-shortcodes' ),
						'ID'     => __( 'post id', 'gfxbucket-shortcodes' ),
						'author' => __( 'author', 'gfxbucket-shortcodes' ),
						'title'  => __( 'title', 'gfxbucket-shortcodes' ),
						'name'   => __( 'post name (post slug)', 'gfxbucket-shortcodes' ),
						'rand'   => __( 'random', 'gfxbucket-shortcodes' ),
					)
				),
				'order' => array(
					'type' => 'select',
					'label' => __( 'Order Type', 'gfxbucket-shortcodes' ),
					'default' => '',
					'options' => array(
						'DESC' => __( 'Descending', 'gfxbucket-shortcodes' ),
						'ASC'  => __( 'Ascending', 'gfxbucket-shortcodes' ),
					)
				),
				'below_title' => array(
					'type' => 'select',
					'label' => __( 'Below title show', 'gfxbucket-shortcodes' ),
					'default' => '',
					'options' => array(
						'categories' => __( 'categories', 'gfxbucket-shortcodes' ),
						'short-desc' => __( 'short description', 'gfxbucket-shortcodes' ),
						'none'       => __( 'nothing', 'gfxbucket-shortcodes' ),
					)
				),
				'per_page' => array(
					'type'    => 'number',
					'label'   => __( 'Post per page', 'gfxbucket-shortcodes' ),
					'default' => 8
				),
				'filter'   => array(
					'type'    => 'checkbox',
					'label'   => __( 'Show filter', 'gfxbucket-shortcodes' ),
					'default' => true
				),
				'load_more'   => array(
					'type'    => 'checkbox',
					'label'   => __( 'Show "Load More" button', 'gfxbucket-shortcodes' ),
					'default' => true
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-portfolio', __FILE__, 'Gfxbucket_Portfolio');