<?php
	$categories = get_the_category(get_the_id());
	$category_list = '';

	if($categories) {
		foreach ($categories as $category) {
			if( $category_list != '' ) {
				$category_list .= ', ';
			}
			$category_list .= $category->name;
		}
	}

	$tags_list = get_the_tags();
?>

<h2 class="section-title"><?php the_title(); ?></h2>

<div class="blog-post-author">
	<div class="blog-post-author-details">
		<?php _e( 'By', 'dropout' ); ?> <span class="author-name"><?php the_author(); ?></span> 
		<?php _e( 'on', 'dropout' ); ?> <time datetime="2014-09-10 17:00"><?php echo get_the_date('M jS, Y'); ?></time> 
		<?php _e( 'in', 'dropout' ); ?> <span class="categories"><?php echo esc_html( $category_list ); ?></span>
	</div>
</div>

<article id="post-<?php the_ID(); ?>" <?php post_class('blog-post'); ?>>
	<div class="blog-post-content">
		<?php the_content(); ?>
	</div>
	<div class="blog-post-meta text-center">
		<div class="share">
			<span class='st_fblike_hcount' displayText='Facebook Like'></span>
			<span class='st_facebook_hcount' displayText='Facebook'></span>
			<span class='st_twitter_hcount' displayText='Tweet'></span>
			<span class='st_pinterest_hcount' displayText='Pinterest'></span>
			<span class='st_linkedin_hcount' displayText='LinkedIn'></span>
		</div>

		<ul class="blog-post-categories">
			<?php
				$categories = get_the_category();

				foreach ($categories as $category) {
					echo '<li><a href="' . get_category_link( $category->term_id ) . '">' . esc_html( $category->name ) . '</a></li>';
				}
			?>
		</ul>
	</div>
</article>

<script type="text/javascript" src="http://w.sharethis.com/button/buttons.js"></script>
<script type="text/javascript">stLight.options({publisher: "ur-5fdb4f67-c1c0-744-d2c9-e68f87551a7e", doNotHash: false, doNotCopy: false, hashAddressBar: false});</script>