<?php

if ( ! isset( $content_width ) ) {
	$content_width = 600;
}

/**
 * Post Comments
 */

function gfxbucket_comment($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}
?>
	<<?php echo esc_attr( $tag ); ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
	<?php if ( 'div' != $args['style'] ) : ?>
	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	<?php endif; ?>
	<div class="comment-meta">
		<div class="comment-author vcard">
			<?php if ( $args['avatar_size'] != 0 ) { echo get_avatar( $comment, $args['avatar_size'] ); } ?>
			<?php printf( __( '%s', 'dropout' ), get_comment_author_link() ); ?>
			
			<span class="comment-reply-link">
				<?php comment_reply_link( array_merge( $args, array( 'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			</span>
		</div>

		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'dropout' ); ?></em>
			<br />
		<?php endif; ?>

		<span class="comment-metadata" href="<?php echo esc_url( htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ); ?>">
			<?php printf( __( '%1$s at %2$s', 'dropout' ), get_comment_date(),  get_comment_time() ); ?>
			<?php edit_comment_link( __( 'Edit', 'dropout' ), '  ', '' ); ?>
		</span>
	</div>

	<?php comment_text(); ?>

	<?php if ( 'div' != $args['style'] ) : ?>
	</div>
	<?php endif; ?>
<?php
}

/**
 * Includes (helper functions, framework, widgets)
 */

// Redux Framework
require_once( dirname(__FILE__) . '/includes/redux-extension-loader.php' );
require_once( dirname(__FILE__) . '/includes/options-config.php' );

// Widgets
require_once( dirname(__FILE__) . '/includes/widgets/social.php' );
require_once( dirname(__FILE__) . '/includes/widgets/contact_info.php' );

// Page Meta Class
require_once( dirname(__FILE__) . '/includes/GfxbucketPageMeta.php' );

// Ajax Functions (Blog, Portfolio)
require_once( dirname(__FILE__) . '/includes/ajax-functions.php' );

// Demo Importer
require_once( dirname(__FILE__) . '/includes/demo-importer.php' );
require_once( dirname(__FILE__) . '/includes/tgm/class-tgm-plugin-activation.php' );
require_once( dirname(__FILE__) . '/includes/tgm/plugins.php' );

/**
 * Main Theme Class (all main functions)
 */

class Gfxbucket {
	function __construct() {
		add_action( 'after_setup_theme', array($this, 'theme_init') );
		add_action( 'admin_menu', array($this, 'create_post_meta_box') );
		add_action( 'save_post', array($this, 'save_meta_box') );
		add_filter( 'post_class', array($this, 'category_id_class') );
		add_action( 'get_header', array($this, 'remove_admin_login_header') );
		add_filter( 'upload_mimes', array($this, 'custom_mtypes') );
		add_filter( 'portfolioposttype_args', array($this, 'portfolioposttype_custom') );
		add_filter( 'excerpt_more', array($this, 'new_excerpt_more') );
		add_action( 'widgets_init', array($this, 'widgets_init') );
		add_action( 'wp_enqueue_scripts', array($this, 'scripts') );
		add_action( 'admin_enqueue_scripts', array($this, 'admin_style') );
		add_action( 'admin_init', array($this, 'editor_styles') );
	}

	/**
	 * Make adjustments on theme setup (translation, theme suppport, widget areas and navigation area)
	 */

	function theme_init() {
		// Make theme available for translation

		load_theme_textdomain( 'dropout', get_template_directory() . '/languages' );

		// Add support for post and comment RSS feed links to head

		add_theme_support( 'automatic-feed-links' );

		// Add support for plugins and themes to manage the document title

		add_theme_support( 'title-tag' );

		// Add support for Post Thumbnails

		add_theme_support( 'post-thumbnails' );

		// Add support for the use of HTML5 markup for the comment lists, comment forms, search forms and galleries

		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );

		// This theme uses wp_nav_menu() in one location.

		register_nav_menus( array(
			'primary' => __( 'Primary Menu', 'dropout' ),
		) );

		// Image size

		add_image_size( 'blog-masonry-three', 360, 0 );
		add_image_size( 'blog', 770, 440, true );
		add_image_size( 'blog-strip', 9999, 400, true );

		add_image_size( 'portfolio-post', 500, 500, true );
		add_image_size( 'portfolio-post-large', 1000, 500, true );
		add_image_size( 'portfolio-post-large-2', 900, 675, true );
		add_image_size( 'portfolio-4-columns', 400, 300, true );

		// Remove default bottom margin and add Page Builder to portfolio post type

		$temp = get_option('siteorigin_panels_settings');

		if ( !isset($temp['post-types']) ) {
			$temp['post-types'] = array();

			array_push($temp['post-types'], 'page');
			array_push($temp['post-types'], 'post');
			array_push($temp['post-types'], 'portfolio');
		}

		if ( !in_array('portfolio', $temp['post-types']) ) {
			array_push($temp['post-types'], 'portfolio');
		}

		$temp['margin-bottom'] = 'none';
		update_option('siteorigin_panels_settings', $temp);
	}

	/**
	 * Header Logo
	 */

	public static function logo() {
		global $gfxbucket_options;

		/* Default Logo URLs */
		$logo_url = get_template_directory_uri() . '/images/demo/logo.svg';
		$logo_light_url = get_template_directory_uri() . '/images/demo/logo-light.svg';

		/* Check if logo is set */
		if( isset($gfxbucket_options['gfxbucket-logo']['url']) && $gfxbucket_options['gfxbucket-logo']['url'] != '' ) {
			$logo_url = $gfxbucket_options['gfxbucket-logo']['url'];
		}

		/* Check if light logo is set */
		if( isset($gfxbucket_options['gfxbucket-logo-light']['url'])  && $gfxbucket_options['gfxbucket-logo-light']['url'] != '' ) {
			$logo_light_url = $gfxbucket_options['gfxbucket-logo-light']['url'];
		}

		$id = get_the_id();
		if( is_home() && get_option('page_for_posts') ) {
			$id = get_option('page_for_posts');
		}

		$gfxbucket_header_style = esc_attr( get_post_meta( $id, '_gfxbucket_header_style', true ) );

		if( !$gfxbucket_header_style ) {
			$gfxbucket_header_style = $gfxbucket_options['gfxbucket-header-style'];
		}

		if( $gfxbucket_header_style == 3 || $gfxbucket_header_style == 4 ) {
			$logo_light_url = '';
		}

		/* Return logo */
		echo '<a href="' . esc_url( home_url( '/' ) ) . '" class="site-logo" data-light="' . $logo_light_url . '"><img src="' . $logo_url  . '" alt="' . get_bloginfo( 'name' ) . '" /></a>';
	}

	/**
	 * Navigation Toggle
	 */

	public static function nav_toggle() {
		if ( has_nav_menu('primary') ) {
			echo '<button class="nav-toggle"><svg><use xlink:href="#shape-nav"></use></svg></button>';
		} else {
			_e( '<span class="header-message">Define your primary navigation under Appearance - Menus.</span>', 'dropout' );
		}
		
	}

	/**
	 * Site header
	 */

	public static function header() {
		global $gfxbucket_options;

		$id = get_the_id();
		if( is_home() && get_option('page_for_posts') ) {
			$id = get_option('page_for_posts');
		}

		$gfxbucket_header_style = esc_attr( get_post_meta( $id, '_gfxbucket_header_style', true ) );

		if( !$gfxbucket_header_style ) {
			$gfxbucket_header_style = $gfxbucket_options['gfxbucket-header-style'];
		}

		if( !$gfxbucket_header_style || $gfxbucket_header_style == 1 || $gfxbucket_header_style == 3 || $gfxbucket_header_style == 4 || $gfxbucket_header_style == 6 ):
		?>
			<header class="site-header">
				<div class="nav-row">
					<div class="container">
						<?php Gfxbucket::logo(); ?>

						<?php Gfxbucket::nav_toggle(); ?>
					</div>
				</div>

				<?php Gfxbucket::navigation(); ?>

				<?php Gfxbucket::social_icons(); ?>
			</header>
		<?php
		elseif ( $gfxbucket_header_style == 5 ): ?>
			<header class="site-header">
			  <?php Gfxbucket::logo(); ?>

			  <?php Gfxbucket::navigation(); ?>

			  <?php Gfxbucket::nav_toggle(); ?>

			  <?php Gfxbucket::social_icons(); ?>
			</header>
		<?php elseif ( $gfxbucket_header_style == 2 ): ?>
			<header class="site-header">
			  <div class="nav-row">
			    <div class="container">
			      <?php Gfxbucket::logo(); ?>

			      <?php Gfxbucket::nav_toggle(); ?>

			      <?php Gfxbucket::navigation(); ?>
			    </div>
			  </div>
			</header>
		<?php endif;
	}

	/**
	 * Site main navigation
	 */

	public static function navigation() {
		$id = get_the_id();
		if( is_home() && get_option('page_for_posts') ) {
			$id = get_option('page_for_posts');
		}

		$gfxbucket_menu = esc_attr( get_post_meta( $id, '_gfxbucket_menu', true ) );

		$atts = array(
			'theme_location'  => 'primary',
			'container'       => 'nav',
			'container_class' => 'nav-menu',
			'fallback_cb'     => false,
		);

		if( $gfxbucket_menu ) {
			$atts = array(
				'menu'            => $gfxbucket_menu,
				'container'       => 'nav',
				'container_class' => 'nav-menu',
				'fallback_cb'     => false,
			);	
		}

		wp_nav_menu( $atts );
	}

	/**
	 * Mobile Icon
	 */

	public static function mobile_icon() {
		global $gfxbucket_options;

		if( isset($gfxbucket_options['gfxbucket-mobile-icon']) &&
			isset($gfxbucket_options['gfxbucket-mobile-icon']['url']) &&
			$gfxbucket_options['gfxbucket-mobile-icon']['url'] != '' ) {
			echo '<link rel="apple-touch-icon" href="' . $gfxbucket_options['gfxbucket-mobile-icon']['url'] . '">';
		}
	}

	/**
	 * Styling
	 */

	public static function styling() {
		global $gfxbucket_options;

		echo '<style>';

		if( isset($gfxbucket_options['gxbucket-typography-family']) && $gfxbucket_options['gxbucket-typography-family']['font-family'] != 'Lato' ) {
			echo 'html body { font-family: ' . $gfxbucket_options['gxbucket-typography-family']['font-family'] . ', sans-serif; }';
		}

		if( isset($gfxbucket_options['gxbucket-typography-h1']) ) {
			echo 'body h1 { font-size: ' . $gfxbucket_options['gxbucket-typography-h1'] . 'px; }';
		}

		if( isset($gfxbucket_options['gxbucket-typography-h2']) ) {
			echo 'body h2 { font-size: ' . $gfxbucket_options['gxbucket-typography-h2'] . 'px; }';
		}

		if( isset($gfxbucket_options['gxbucket-typography-h3']) ) {
			echo 'body h3 { font-size: ' . $gfxbucket_options['gxbucket-typography-h3'] . 'px; }';
		}

		if( isset($gfxbucket_options['gxbucket-typography-h4']) ) {
			echo 'body h4 { font-size: ' . $gfxbucket_options['gxbucket-typography-h4'] . 'px; }';
		}

		if( isset($gfxbucket_options['gxbucket-typography-h5']) ) {
			echo 'body h5 { font-size: ' . $gfxbucket_options['gxbucket-typography-h5'] . 'px; }';
		}

		if( isset($gfxbucket_options['gxbucket-typography-h6']) ) {
			echo 'body h6 { font-size: ' . $gfxbucket_options['gxbucket-typography-h6'] . 'px; }';
		}

		if( isset($gfxbucket_options['gfxbucket-style-color-main']) && $gfxbucket_options['gfxbucket-style-color-main'] != '#1FD7D2' ) {
			echo '.review .review-rating,
				.instagram-author-tag a,
				.nav-side .site-header .nav-menu li.active a,
				.nav-desktop .site-header .nav-menu .active > a,
				.site-header .nav-menu a:hover,
				.site-header .nav-social a:hover,
				.nav-desktop.nav-scroll-active .site-header .nav-menu > ul > li > a:hover,
				body .site-header .nav-menu .current-menu-item > a {
			        color: ' . $gfxbucket_options['gfxbucket-style-color-main'] . ' !important;
			    }

				body .title:before    { background-color: ' . $gfxbucket_options['gfxbucket-style-color-main'] . '; }
			    body ::-moz-selection { background-color: ' . $gfxbucket_options['gfxbucket-style-color-main'] . '; }
			    body ::selection      { background-color: ' . $gfxbucket_options['gfxbucket-style-color-main'] . '; }
			';
		}

		if( isset($gfxbucket_options['gfxbucket-style-color-text']) && $gfxbucket_options['gfxbucket-style-color-text'] != '#777777' ) {
			echo 'html body,
			    body a,
			    body .portfolio a:hover,
			    body .icon .icon-content,
			    body .recent-posts article:hover a,
			    body .recent-posts article a:hover,
			    body .blog-post-categories a:hover,
			    body .portfolio-content .portfolio-post-header-meta,
			    body .portfolio-content .portfolio-post-header-description,
			    body .panel-default .panel-title > a.collapsed,
			    body .nav-scroll-active.background--dark .header-message,
			    body .site-footer.style-2 a,
				body .site-footer.style-2,
				body .widget_recent_entries .post-date,
				body .portfolio-post-header.no-background .portfolio-post-header-meta,
				body .portfolio-post-header.no-background .portfolio-post-header-description {
					color: ' . $gfxbucket_options['gfxbucket-style-color-text'] . ';
				}';
		}

		if( isset($gfxbucket_options['gfxbucket-style-color-heading']) && $gfxbucket_options['gfxbucket-style-color-heading'] != '#222222' ) {
			echo 'body .more, body .more:hover,
				body .counter span,
				body .filter button.selected, body .filter button:hover,
				body a:hover,
				body h1, body h2, body h3, body h4, body h5, body h6,
				body input[type="text"], body input[type="email"], body input[type="tel"], body input[type="number"], body input[type="password"], body textarea, body select,
				body label,
				body .nav-side .site-header .nav-menu a,
				body .blog-post-author span,
				body .blog-post-author time,
				body .btn:hover, body .btn:focus,
				body th,
				body dt,
				body strong {
					color: ' . $gfxbucket_options['gfxbucket-style-color-heading'] . ';
				}

				body .site-header .nav-toggle svg,
				body.nav-scroll-active .site-header .nav-toggle svg {
					stroke: ' . $gfxbucket_options['gfxbucket-style-color-heading'] . ';
				}

				body .btn:hover, body .btn:focus, body .btn:active {
					border-color: ' . $gfxbucket_options['gfxbucket-style-color-heading'] . ';
				}

				body .more:after, body .blog-more:after {
					  border-left-color: ' . $gfxbucket_options['gfxbucket-style-color-heading'] . ';
				}';
		}

		echo '</style>';
	}

	/**
	 * Favicon
	 */

	public static function favicon() {
		global $gfxbucket_options;

		if( isset($gfxbucket_options['gfxbucket-favicon']) &&
			isset($gfxbucket_options['gfxbucket-favicon']['url']) &&
			$gfxbucket_options['gfxbucket-favicon']['url'] != '' ) {
			echo '<link rel="shortcut icon" href="' . esc_url( $gfxbucket_options['gfxbucket-favicon']['url'] ) . '">';
		} else {
			echo '<link rel="shortcut icon" href="' . get_template_directory_uri() . '/images/demo/favicon.png' . '">';
		}
	}

	/**
	 * Page Cover
	 */

	public static function page_cover() {
		$id = get_the_id();

		if( is_home() && get_option('page_for_posts') ) {
			$id = get_option('page_for_posts');
		}
		
		$background_image = wp_get_attachment_url( get_post_thumbnail_id($id) );
		$gfxbucket_status = esc_attr( get_post_meta( $id, '_gfxbucket_cover_status', true ) );
		$gfxbucket_title_status = esc_attr( get_post_meta( $id, '_gfxbucket_cover_title_status', true ) );
		$gfxbucket_search = esc_attr( get_post_meta( $id, '_gfxbucket_cover_search', true ) );
		$gfxbucket_title = esc_attr( get_post_meta( $id, '_gfxbucket_cover_title', true ) );
		$gfxbucket_subtitle = esc_attr( get_post_meta( $id, '_gfxbucket_cover_subtitle', true ) );

		if( $gfxbucket_status != '1' || is_home() || is_category()  || is_archive() || is_search() ) {
			return '';
		}

		if( $gfxbucket_title == '' ) {
			$gfxbucket_title = get_the_title($id);
		}

		$class = 'page-cover parallax';

		if( get_post_type( $id ) == 'page' ) {
			$class .= ' style-2';
		}

		?>

		<div class="<?php echo esc_attr( $class ); ?>" style="background-image: url(<?php echo esc_attr( $background_image ); ?>);">
			<div class="page-cover-content">
				<?php if( $gfxbucket_search != '2' ): ?>
					<?php get_search_form(); ?>
				<?php endif; ?>
				<?php if( $gfxbucket_title_status != '2' ): ?>
					<h2><?php echo esc_attr( $gfxbucket_title ); ?></h2>
				<?php endif; ?>
				<?php if( $gfxbucket_subtitle != '' ): ?>
					<h4><?php echo esc_attr( $gfxbucket_subtitle ); ?></h4>
				<?php endif; ?>
			</div>
		</div>

		<?php
	}


	/**
	 * Breadcrumbs
	 */

	public static function breadcrumbs() {
		global $gfxbucket_options;

		$breadcrumbs_class = 'page-title';

		$id = get_the_id();

		if( get_option('page_for_posts') ) {
			$id = get_option('page_for_posts');
		} else if ( is_category() ) {
			//var_dump(single_cat_title( '', true ));
		}

		$breadcrumbs_meta = esc_attr( get_post_meta( $id, '_gfxbucket_breadcrumbs', true ) );
		$breadcrumbs_status = false;
		if( isset($gfxbucket_options['gfxbucket-breadcrumbs']) ) {
			$breadcrumbs_status = $gfxbucket_options['gfxbucket-breadcrumbs'];
		}
		$gfxbucket_status = esc_attr( get_post_meta( $id, '_gfxbucket_cover_status', true ) );

		$breadcrumbs_spacing = esc_attr( get_post_meta( $id, '_gfxbucket_breadcrumbs_spacing', true ) );

		if( $breadcrumbs_spacing == '2' ) {
			$breadcrumbs_class .= ' page-title-no-spacing';
		}

		if( ($breadcrumbs_status || $breadcrumbs_meta == '1') && $breadcrumbs_meta != '2' && $gfxbucket_status != '1' && !is_home() && !(is_single() && get_post_type() == 'portfolio') ) {
			?>
				<section class="<?php echo $breadcrumbs_class; ?>">
					<div class="container">
						<div class="row">
							<div class="col-md-12">
								<div class="page-title-content">
									<h2 class="page-title-heading"><?php echo esc_html( get_the_title($id) ); ?></h2>

									<ul class="breadcrumbs">
										<li><a href="<?php echo esc_url( home_url() ); ?>"><?php _e( 'Home', 'dropout' ); ?></a></li>
										<?php
											if (is_category() || is_single()) {
												echo '<li><a href="' . get_permalink( get_option('page_for_posts') ) . '">' . get_the_title( get_option('page_for_posts') ) . '</a></li>';
												
												$categories = get_the_category($id);

												foreach ($categories as $category) {
													echo '<li><a href="' . get_category_link( $category->term_id ) . '">' . $category->cat_name . '</a></li>';
												}


											} else {
												// Parent pages
												$ancestors = get_post_ancestors($id);

												for($i=count($ancestors)-1;$i>=0;$i--) {
													echo '<li><a href="' . get_permalink($ancestors[$i]) . '">' . get_the_title($ancestors[$i]) . '</a></li>';
												}
											}
										?>
										<li><span><?php echo esc_html( get_the_title($id) ); ?></span></li>
									</ul>
								</div>	
							</div>
						</div>
					</div>
				</section>
			<?php
		}
	}

	/**
	 * Footer
	 */

	public static function footer() {
		global $gfxbucket_options;

		// Check if footer is hidden on this page

		$id = get_the_id();
		if( is_home() && get_option('page_for_posts') ) {
			$id = get_option('page_for_posts');
		}

		$gfxbucket_footer = esc_attr( get_post_meta( $id, '_gfxbucket_footer', true ) );

		if( $gfxbucket_footer == '2' && !is_search() ) {
			return false;
		}

		// Default Copyright Value
		$copyright = __( 'Copyright &#169; Made with Love & Caffeine by Gfxbucket. All Rights Reserved.', 'dropout' );

		// Check, Set Copyright Value
		if( isset($gfxbucket_options['gfxbucket-copyright-text']) ) {
			$copyright = $gfxbucket_options['gfxbucket-copyright-text'];
		}

		$class = ' style-1';

		if( isset($gfxbucket_options['gfxbucket-footer-style']) && $gfxbucket_options['gfxbucket-footer-style'] == 2 ) {
			$class = ' style-2';
		}

		$num_sidebars = $gfxbucket_options['gfxbucket-footer-type'];

		?>

		<footer class="site-footer<?php echo esc_attr( $class ); ?>">
			<?php if( $num_sidebars == 1 ): ?>
				<?php if( is_active_sidebar( 'gfxbucket-footer-1' ) ): ?>
					<div class="footer-content">
						<div class="container">
							<?php dynamic_sidebar( 'gfxbucket-footer-1' ); ?>
						</div>
					</div>
				<?php endif; ?>
			<?php elseif( $num_sidebars > 1 ): 
				echo '<div class="container"><div class="row">';
				for($i=1;$i<=4;$i++) {
					echo '<div class="col-md-' . 12 / $num_sidebars . '">';
					if( is_active_sidebar( 'gfxbucket-footer-' . $i ) ) {
						dynamic_sidebar( 'gfxbucket-footer-' . $i );
					}
					echo '</div>';
				}
				echo '</div></div>';
			?>
			<?php endif; ?>
	
			<?php if( $copyright != '' ):
				$wp_kses_attr = array(
					'a' => array(
						'href' => array(),
						'title' => array(),
					),
					'em' => array(),
					'strong' => array()
				);
			?>
				<div class="copyright">By entering this site you are accepting the <a href="/downloads/terminos-y-condiciones.pdf" target="_blank">Terms and Conditions and the Basis Protection Policies of Data</a> from Contract Workplaces. </div>
			<?php endif; ?>
		</footer>

		<?php

		if( isset($gfxbucket_options['gfxbucket-custom-js']) && $gfxbucket_options['gfxbucket-custom-js'] ) {
			echo '<script>' . $gfxbucket_options['gfxbucket-custom-js'] . '</script>';
		}
	}

	/**
	 * Add extra clases to the body element
	 */

	public static function body_class() {
		global $gfxbucket_options;
		$return = '';

		$id = get_the_id();
		if( (is_home() || is_category() || is_archive() || is_search()) ) {
			$id = get_option('page_for_posts');
		}

		/* Navigation Type */

		$gfxbucket_header_style = esc_attr( get_post_meta( $id, '_gfxbucket_header_style', true ) );

		if( !$gfxbucket_header_style ) {
			$gfxbucket_header_style = $gfxbucket_options['gfxbucket-header-style'];
		}

		switch( $gfxbucket_header_style ) {
			case '1': $return .= 'nav-default'; break;
			case '2': $return .= 'nav-desktop'; break;
			case '3': $return .= 'nav-bottom'; break;
			case '4': $return .= 'nav-top'; break;
			case '5': $return .= 'nav-side'; break;
			case '6': $return .= 'nav-default nav-default-style-2'; break;
			default:  $return .= 'nav-default nav-sticky';
		}

		/* Add Site Loaded if preload is not set */

		if( ! isset($gfxbucket_options['gfxbucket-preloader']) && $gfxbucket_options['gfxbucket-preloader'] != '2' ) {
			$return .= ' site-loaded';
		}

		/* Header Social */

		if( ! isset($gfxbucket_options['gfxbucket-social-status']) || $gfxbucket_options['gfxbucket-social-status'] == '0' ) {
			$return .= ' header-no-social';
		} else {
			$socials = array('facebook', 'twitter', 'google-plus', 'linkedin', 'dribbble', 'behance', 'tumblr', 'instagram', 'pinterest', 'youtube', 'vimeo-square', 'github');
			$temp_return = ' header-no-social';

			foreach( $socials as $social ) {
				if( isset($gfxbucket_options['gfxbucket-social-' . $social]) && $gfxbucket_options['gfxbucket-social-' . $social] != '' ) {
					$temp_return = '';
					break;
				}
			}

			$return .= $temp_return;
		}

		/* Menu Scroll */

		$gfxbucket_header_scroll = esc_attr( get_post_meta( $id, '_gfxbucket_header_scroll', true ) );

		if( $gfxbucket_header_scroll == '2' ) {
			$return .= ' nav-scroll';
		} else if( $gfxbucket_header_scroll == '3' ) {
			$return .= ' nav-scroll-disabled';
		}

		/* Menu Text Style */

		$gfxbucket_menu_style = esc_attr( get_post_meta( $id, '_gfxbucket_menu_style', true ) );

		if( $gfxbucket_menu_style == '2' ) {
			$return .= ' background--dark';
		}

		/* Sticky Navigation */

		if( isset($gfxbucket_options['gfxbucket-header-sticky']) && $gfxbucket_options['gfxbucket-header-sticky'] && (intval($gfxbucket_header_style) < 3 || intval($gfxbucket_header_style) > 5) ) {
			$return .= ' nav-sticky';
		} else if( intval($gfxbucket_header_style) != 3 ) {
			$return .= ' nav-sticky-disabled';
		}

		/* Header Spacing */

		$gfxbucket_header_spacing = esc_attr( get_post_meta( $id, '_gfxbucket_header_spacing', true ) );

		$breadcrumbs_meta = esc_attr( get_post_meta( $id, '_gfxbucket_breadcrumbs', true ) );
		$breadcrumbs_status = false;
		if( isset($gfxbucket_options['gfxbucket-breadcrumbs']) ) {
			$breadcrumbs_status = $gfxbucket_options['gfxbucket-breadcrumbs'];
		}

		if( ($gfxbucket_header_spacing != '2' && $breadcrumbs_meta != '1' && !$breadcrumbs_status) || is_home() ) {
			$return .= ' page-spacing';
		} else {
			$return .= ' page-spacing-off';
		}

		/* Footer Spacing */

		$gfxbucket_footer_spacing = esc_attr( get_post_meta( $id, '_gfxbucket_footer_spacing', true ) );

		if( $gfxbucket_footer_spacing == '2' ) {
			$return .= ' footer-no-spacing';
		}

		/* Layout Style (full width / boxed) */

		if( isset($gfxbucket_options['gfxbucket-layout-style']) && $gfxbucket_options['gfxbucket-layout-style'] == '2' ) {
			$return .= ' boxed';
		}

		return $return;
	}

	/**
	 * Preloader
	 */

	public static function preloader() {
		global $gfxbucket_options;

		if( isset($gfxbucket_options['gfxbucket-preloader']) && $gfxbucket_options['gfxbucket-preloader'] ) {
			if( isset($gfxbucket_options['gfxbucket-preloader-image']['url']) && $gfxbucket_options['gfxbucket-preloader-image']['url'] != '' ) {
				echo '<div class="preloader"><img src="' . $gfxbucket_options['gfxbucket-preloader-image']['url'] . '" alt="' . get_bloginfo( 'name' ) . '"></div>';
			} elseif( isset($gfxbucket_options['gfxbucket-logo']['url']) && $gfxbucket_options['gfxbucket-logo']['url'] != '' ) {
				echo '<div class="preloader"><img src="' . $gfxbucket_options['gfxbucket-logo']['url'] . '" alt="' . get_bloginfo( 'name' ) . '"></div>';
 			} else {
				echo '<div class="preloader"><img src="' . get_template_directory_uri() . '/images/demo/logo.svg' . '" alt="' . get_bloginfo( 'name' ) . '"></div>';
			}
		}
	}

	/**
	 * Social Icons
	 */

	public static function social_icons() {
		$return = '';
		$socials = array('facebook', 'twitter', 'google-plus', 'linkedin', 'dribbble', 'behance', 'tumblr', 'instagram', 'pinterest', 'youtube', 'vimeo-square', 'github');

		global $gfxbucket_options;

		if( $gfxbucket_options['gfxbucket-social-status'] ) {
			foreach( $socials as $social ) {
				if( isset($gfxbucket_options['gfxbucket-social-' . $social]) && $gfxbucket_options['gfxbucket-social-' . $social] != '' ) {
					$return .= '<li><a href="' . $gfxbucket_options['gfxbucket-social-' . $social] . '" target="_blank"><i class="fa fa-' . $social . '"></i></a></li>';
				}
			}

			if( isset($gfxbucket_options['gfxbucket-social-custom']) && $gfxbucket_options['gfxbucket-social-custom'] ) {
				$custom_icons = explode('|', $gfxbucket_options['gfxbucket-social-custom']);
				
				foreach ($custom_icons as $icon) {
					$icon = explode(';', $icon);
					$icon_val = $icon[0];
                    $icon_url = $icon[1];

					$return .= '<li><a href="' . $icon_url . '" target="_blank"><i class="fa ' . $icon_val . '"></i></a></li>';
				}
			}

			if( $return ) {
				$return = '<ul class="nav-social">' . $return . '</ul>';
			}
		}
		
		$wp_kses_attr = array(
			'a' => array(
				'href' => array(),
				'title' => array(),
				'target' => array(),
			),
			'i' => array(
				'class' => array(),
			),
			'ul' => array(
				'class' => array(),
			),
			'li' => array(
				'class' => array(),
			),
		);

		echo wp_kses( $return, $wp_kses_attr );
	}

	public static function portfolio_header($meta, $background_support) {
		$header_class = ' no-background';
		$header_size = 'col-md-10 col-md-offset-1';
		
		/* Header Background Image */
		$background_image = '';

		if( isset($meta['_gfxbucket_cover_image_url']) && $meta['_gfxbucket_cover_image_url'][0] && $background_support ) {
			$header_class = ' parallax portfolio-header-cover';
			$header_size = 'col-md-12';
			$background_image = wp_get_attachment_url( $meta['_gfxbucket_cover_image_url'][0] );
		}

		/* Header Meta */
		$header_meta = '';

		foreach( $meta as $key => $value ) {		
			if( substr($key, 0, 1) != '_' && $key != 'slide_template' && $key != 'panels_data' && $key != 'portfolio_description' ) {
				$header_meta .= '<li><strong>' . $key . ':</strong> ' . $value[0] . '</li>';
			}
		}

		$wp_kses_attr = array(
			'li' => array(),
			'strong' => array(),
		);

		?>

		<div class="portfolio-post-header<?php echo esc_attr( $header_class ); ?>" style="background-image: url(<?php echo esc_url( $background_image ); ?>);">
			<div class="container">
				<div class="row">
					<div class="<?php echo esc_attr( $header_size ); ?>">
						<div class="portfolio-post-header-content">
							<h2 class="portfolio-post-header-heading"><?php the_title(); ?></h2>
							<div class="social">
								<strong><?php _e( 'Share the project', 'dropout' ); ?></strong>
								<ul>
									<li><a href="http://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="fa fa-facebook"></i></a></li>
									<li><a href="https://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php the_permalink(); ?>"><i class="fa fa-twitter"></i></a></li>
								<li><a href="http://pinterest.com/pin/create/link/?url=<?php the_permalink(); ?>"><i class="fa fa-pinterest"></i></a></li>
									<li><a href="https://plus.google.com/share?url=<?php the_permalink(); ?>"><i class="fa fa-google-plus"></i></a></li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="container element element-spacing no-bg">
			<h2 class="portfolio-post-header-heading"><?php the_title(); ?></h2>
			<h3 class="portfolio-post-header-heading-small">Ficha de la Obra <small></small></h3>

			<?php if( $header_meta ): ?>
				<ul class="portfolio-post-header-meta">
					<?php echo wp_kses( $header_meta, $wp_kses_attr ); ?>
				</ul>
			<?php endif; ?>
			<?php if( isset($meta['portfolio_description']) && !$background_support ): ?>
				<p class="portfolio-post-header-description">
					<?php echo do_shortcode(esc_html( $meta['portfolio_description'][0]) ); ?>
				</p>
			<?php endif; ?>
		</div>

		<?php if( isset($meta['portfolio_description']) && $background_support ): ?>
			<div class="container element element-spacing">
				<div class="col-md-10 col-md-offset-1">					

					<p class="portfolio-single-description"><?php echo do_shortcode(esc_html( $meta['portfolio_description'][0]) ); ?></p>
				</div>
			</div>
		<?php endif;
	}

	/**
	 * Portfolio Social Icons
	 */

	public static function social_portfolio_icons() {
		global $gfxbucket_options;

		if( $gfxbucket_options['gfxbucket-portfolio-social-status'] ): ?>
			
		<?php endif;
	}

	/**
	 * Add Meta Boxes
	 */

	function create_post_meta_box() {
		add_meta_box( 'gfxbucket-meta-box', __( 'Page Options', 'dropout' ), array($this, 'meta_box'), 'page', 'normal', 'high' );
		add_meta_box( 'gfxbucket-meta-box', __( 'Post Options', 'dropout' ), array($this, 'meta_box'), 'post', 'normal', 'high' );
		add_meta_box( 'gfxbucket-meta-box', __( 'Cover Image', 'dropout' ), array($this, 'meta_box_portfolio'), 'portfolio', 'side', 'low' );
	}

	/**
	 * Post/Page Meta Boxes
	 */

	function meta_box( $post ) {
		global $gfxbucket_options;

		wp_nonce_field( 'myplugin_meta_box', 'myplugin_meta_box_nonce' );


		/* Sidebar Options */

		echo '<h3 class="gfxbucket-meta-heading">' . __( 'Sidebar Options', 'dropout' ). '</h3>';

		$sidebar_options = array(
			new GfxbucketPageMeta(
				'sidebar_status',
				__( 'Sidebar Status', 'dropout' ),
				__( 'Select sidebar status (none, left sidebar or right sidebar).', 'dropout' ),
				$post->ID,
				'select',
				array(
					'0' => '',
					'1' => __( 'Left sidebar', 'dropout' ),
					'2' => __( 'Right sidebar', 'dropout' ),
					'3' => __( 'None', 'dropout' ),
				)
			)
		);

		foreach ($sidebar_options as $sidebar_option) {
			$sidebar_option->gfxbucketGetPageMeta();
		}

		/* Cover Options */

		echo '<h3 class="gfxbucket-meta-heading">' . __( 'Cover Options', 'dropout' ). '</h3>';

		$cover_options = array(
			new GfxbucketPageMeta(
				'cover_status',
				__( 'Cover Status', 'dropout' ),
				__( 'Enable/Disable the cover.', 'dropout' ),
				$post->ID,
				'select',
				array(
					'2' => __( 'Disable', 'dropout' ),
					'1' => __( 'Enable', 'dropout' )
				)
			),
			new GfxbucketPageMeta(
				'cover_title_status',
				__( 'Cover Title Status', 'dropout' ),
				__( 'Hide/Show cover title.', 'dropout' ),
				$post->ID,
				'select',
				array(
					'1' => __( 'Show', 'dropout' ),
					'2' => __( 'Hide', 'dropout' )
				)
			),
			new GfxbucketPageMeta(
				'cover_title',
				__( 'Cover Title', 'dropout' ),
				__( 'This will overwrite the main title. Can be useful if you want a different text at the top, instead of the main title.', 'dropout' ),
				$post->ID,
				'text',
				array()
			),
			new GfxbucketPageMeta(
				'cover_subtitle',
				__( 'Cover Subtitle', 'dropout' ),
				__( 'Optional subtitle to show under the cover title.', 'dropout' ),
				$post->ID,
				'text',
				array()
			),
			new GfxbucketPageMeta(
				'cover_search',
				__( 'Cover Search', 'dropout' ),
				__( 'Hide/Show cover search input.', 'dropout' ),
				$post->ID,
				'select',
				array(
					'1' => __( 'Show', 'dropout' ),
					'2' => __( 'Hide', 'dropout' )
				)
			)
		);

		foreach ($cover_options as $cover_option) {
			$cover_option->gfxbucketGetPageMeta();
		}

		/* Header Options */

		echo '<h3 class="gfxbucket-meta-heading">' . __( 'Header Options', 'dropout' ) . '</h3>';

		$header_options = array(
			new GfxbucketPageMeta(
				'header_style',
				__( 'Header Style', 'dropout' ),
				__( 'Overwrite the "Header Style" for this page. The primary option, is set under Theme Options - Header & Navigation.', 'dropout' ),
				$post->ID,
				'select',
				array(
					'0' => '',
					'1' => __( 'Default', 'dropout' ),
					'2' => __( 'Desktop', 'dropout' ),
					'3' => __( 'Bottom', 'dropout' ),
					'4' => __( 'Top', 'dropout' ),
					'5' => __( 'Side', 'dropout' ),
					'6' => __( 'Minimal', 'dropout' )
				)
			),
			new GfxbucketPageMeta(
				'header_scroll',
				__( 'Header Scroll', 'dropout' ),
				__( 'Navigation bar changes style once scrolled.', 'dropout' ),
				$post->ID,
				'select',
				array(
					'1' => __( '', 'dropout' ),
					'2' => __( 'On', 'dropout' ),
					'3' => __( 'Off', 'dropout' ),
				)
			),
			new GfxbucketPageMeta(
				'menu',
				__( 'Menu', 'dropout' ),
				__( 'Overwrite the "Primary Menu" for this page. The primary option, is set under Appearance - Menus.', 'dropout' ),
				$post->ID,
				'select',
				array()
			),
			new GfxbucketPageMeta(
				'menu_style',
				__( 'Menu Text Style', 'dropout' ),
				__( 'Manually select whether the navigation text is dark or light (by default #222 or #fff).', 'dropout' ),
				$post->ID,
				'select',
				array(
					'1' => __( 'Dark', 'dropout' ),
					'2' => __( 'Light', 'dropout' ),
				)
			),
			new GfxbucketPageMeta(
				'header_spacing',
				__( 'Header Spacing', 'dropout' ),
				__( 'Turn on/off spacing between header and content.', 'dropout' ),
				$post->ID,
				'select',
				array(
					'1' => __( 'On', 'dropout' ),
					'2' => __( 'Off', 'dropout' ),
				)
			),
			new GfxbucketPageMeta(
				'breadcrumbs',
				__( 'Breadcrumbs', 'dropout' ),
				__( 'Hide/Show breadcrumbs.', 'dropout' ),
				$post->ID,
				'select',
				array(
					'0' => __( '', 'dropout' ),
					'1' => __( 'Show', 'dropout' ),
					'2' => __( 'Hide', 'dropout' ),
				)
			),
			new GfxbucketPageMeta(
				'breadcrumbs_spacing',
				__( 'Breadcrumbs Spacing', 'dropout' ),
				__( 'Turn on/off spacing between breadcrumbs and the content.', 'dropout' ),
				$post->ID,
				'select',
				array(
					'1' => __( 'On', 'dropout' ),
					'2' => __( 'Off', 'dropout' ),
				)
			)
		);

		foreach ($header_options as $header_option) {
			$header_option->gfxbucketGetPageMeta();
		}

		/* Footer Options */

		echo '<h3 class="gfxbucket-meta-heading">' . __( 'Footer Options', 'dropout' ) . '</h3>';

		$footer_options = array(
			new GfxbucketPageMeta(
				'footer',
				__( 'Footer', 'dropout' ),
				__( 'Hide/Show footer.', 'dropout' ),
				$post->ID,
				'select',
				array(
					'1' => __( 'Show', 'dropout' ),
					'2' => __( 'Hide', 'dropout' )
				)
			),
			new GfxbucketPageMeta(
				'footer_spacing',
				__( 'Footer Spacing', 'dropout' ),
				__( 'Turn on/off spacing between the content and footer.', 'dropout' ),
				$post->ID,
				'select',
				array(
					'1' => __( 'On', 'dropout' ),
					'2' => __( 'Off', 'dropout' )
				)
			)
		);

		foreach ($footer_options as $footer_option) {
			$footer_option->gfxbucketGetPageMeta();
		}
	}

	/**
	 * Portfolio Meta Boxes
	 */

	function meta_box_portfolio( $post ) {
		wp_nonce_field( 'myplugin_meta_box', 'myplugin_meta_box_nonce' );
		$image_url = (get_post_meta( $post->ID, '_gfxbucket_cover_image_url', true )) ? get_post_meta( $post->ID, '_gfxbucket_cover_image_url', true ) : '';
		$image = wp_get_attachment_image( $image_url, 'medium', false, array( 'style' => 'height: auto; max-width: 100%;' ) );

		$hide_remove_button = '';
		$hide_set_button = '';

		if( !$image_url ) {
			$hide_remove_button = ' style="display: none;"';
		} else {
			$hide_set_button = ' style="display: none;"';
			$image = '<a href="#" class="gfxbucket_cover_image_button">' . $image . '</a>';
		}

		echo '<p><div class="gfxbucket_cover_image">' . $image . '</div></p>';
		echo '<input class="gfxbucket_cover_image_url" type="hidden" name="_gfxbucket_cover_image_url" value="'.$image_url.'" />';
		echo '<p class="hide-if-no-js"><a' . $hide_set_button . ' class="gfxbucket_cover_image_button" href="#">' . __ ( 'Set cover image', 'dropout' ) . '</a>';
		echo '<a' . $hide_remove_button . ' class="gfxbucket_cover_image_button_remove" href="#">' . __ ( 'Remove cover image', 'dropout' ) . '</a></p>';
	}

	/**
	 * Save Meta Boxes
	 */

	function save_meta_box( $post_id ) {

		// Check if our nonce is set.
		if ( ! isset( $_POST['myplugin_meta_box_nonce'] ) ) {
			return;
		}

		// Verify that the nonce is valid.
		if ( ! wp_verify_nonce( $_POST['myplugin_meta_box_nonce'], 'myplugin_meta_box' ) ) {
			return;
		}

		// If this is an autosave, our form has not been submitted, so we don't want to do anything.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Check the user's permissions.
		if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {

			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return;
			}

		} else {

			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return;
			}
		}

		/* OK, it's safe for us to save the data now. */
		
		$options = array(
			'_gfxbucket_sidebar_status',
			'_gfxbucket_cover_image_url',
			'_gfxbucket_cover_status',
			'_gfxbucket_cover_title_status',
			'_gfxbucket_cover_title',
			'_gfxbucket_cover_subtitle',
			'_gfxbucket_cover_search',
			'_gfxbucket_header_scroll',
			'_gfxbucket_header_style',
			'_gfxbucket_menu',
			'_gfxbucket_footer',
			'_gfxbucket_header_spacing',
			'_gfxbucket_footer_spacing',
			'_gfxbucket_menu_style',
			'_gfxbucket_breadcrumbs',
			'_gfxbucket_breadcrumbs_spacing');

		foreach ($options as $option) {
			if ( isset( $_POST[$option] ) ) {
				update_post_meta( $post_id, $option, sanitize_text_field( $_POST[$option] ) );
			}
		}
	}

	/**
	 * Add category nicenames in body and post class
	 */

	function category_id_class( $classes ) {
		global $post;

		for ($i=0; $i<count($classes); $i++) {
			if( $classes[$i] == 'portfolio' ) {
				$classes[$i] = 'portfolio-post';
			}
		}

		return $classes;
	}

	/**
	 * Remove WordPress Admin Bar CSS
	 */

	function remove_admin_login_header() {
		remove_action('wp_head', '_admin_bar_bump_cb');
	}

	/**
	 * Add SVG Image Support
	 */

	function custom_mtypes( $m ){
	    $m['svg'] = 'image/svg+xml';
	    $m['svgz'] = 'image/svg+xml';
	    return $m;
	}

	/**
	 * Remove portfolio fields
	 */

	function portfolioposttype_custom( $args ) {
		// Remove Excerpt
		unset($args['supports'][2]);

		// Remove Comments
		unset($args['supports'][4]);

		return $args;
	}

	/**
	 * Change Excerpt More
	 */

	function new_excerpt_more( $more ) {
		return '...';
	}

	/**
	 * Define theme widgets
	 */
	function widgets_init() {
		global $gfxbucket_options;

		/* Sidebars */

		register_sidebar( array(
			'name'          => __( 'Sidebar Right', 'dropout' ),
			'id'            => 'gfxbucket-sidebar-right',
			'description'   => '',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );

		register_sidebar( array(
			'name'          => __( 'Sidebar Left', 'dropout' ),
			'id'            => 'gfxbucket-sidebar-left',
			'description'   => '',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );

		/* Footer sidebars */

		$max_footer = 1;

		if( isset($gfxbucket_options['gfxbucket-footer-type']) ) {
			$max_footer = $gfxbucket_options['gfxbucket-footer-type'];
		}

		for ($i=1; $i<=$max_footer; $i++) {
			$name = __( 'Footer Column ' . $i, 'dropout' );
			$id = 'gfxbucket-footer-' . $i;

			if( $max_footer == 1 ) {
				$name = __( 'Footer Widget Area', 'dropout' );
			}

			register_sidebar( array(
				'name'          => $name,
				'id'            => $id,
				'description'   => '',
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h4 class="widget-title">',
				'after_title'   => '</h4>',
			) );
		}

		/* Theme Widgets */

		register_widget( 'Gfxbucket_Social' );
		register_widget( 'Gfxbucket_Contact_Info' );
	}

	/*
	 * Styles And Scripts (CSS and JavaScript)
	 */
	function scripts() {
		global $gfxbucket_options;

		wp_enqueue_style( 'gfxbucket-style', get_stylesheet_uri() );
		wp_enqueue_style( 'gfxbucket-font-awesome', get_template_directory_uri() . '/css/min/font-awesome.min.css' );
		wp_enqueue_style( 'gfxbucket-font', 'https://fonts.googleapis.com/css?family=Lato:300,400,700,900&subset=latin,latin-ext' );
		wp_enqueue_style( 'gfxbucket-bootstrap', get_template_directory_uri() . '/css/bootstrap.css' );
		wp_enqueue_style( 'gfxbucket-slick', get_template_directory_uri() . '/css/slick.css' );
		wp_enqueue_style( 'gfxbucket-featherlight', get_template_directory_uri() . '/css/featherlight.min.css' );
		wp_enqueue_style( 'gfxbucket-featherlight-gallery', get_template_directory_uri() . '/css/featherlight.gallery.min.css' );
		wp_enqueue_style( 'gfxbucket-global', get_template_directory_uri() . '/css/global.css' );
		wp_enqueue_style( 'gfxbucket-compontents', get_template_directory_uri() . '/css/components.css' );
		wp_enqueue_style( 'gfxbucket-widgets', get_template_directory_uri() . '/css/widgets.css' );
		wp_enqueue_style( 'gfxbucket-wordpress', get_template_directory_uri() . '/css/wordpress.css' );

		wp_add_inline_style( 'gfxbucket-wordpress', $gfxbucket_options['gfxbucket-custom-css-code'] );

		wp_enqueue_script( 'gfxbucket-isotope', get_template_directory_uri() . '/javascript/libraries/isotope.min.js', array('jquery'), '', true );
		wp_enqueue_script( 'gfxbucket-parallax', get_template_directory_uri() . '/javascript/libraries/jquery.parallax.min.js', array('jquery'), '', true );
		wp_enqueue_script( 'gfxbucket-background-check', get_template_directory_uri() . '/javascript/libraries/background-check.min.js', array('jquery'), '', true );
		wp_enqueue_script( 'gfxbucket-images-loaded', get_template_directory_uri() . '/javascript/libraries/imagesloaded.min.js', array('jquery'), '', true );
		wp_enqueue_script( 'gfxbucket-jquery-mb-ytplayer', get_template_directory_uri() . '/javascript/libraries/jquery.mb.YTPlayer.js', array('jquery'), '', true );
		wp_enqueue_script( 'gfxbucket-smooth-scroll', get_template_directory_uri() . '/javascript/libraries/smoothScroll.min.js', array('jquery'), '', true );
		wp_enqueue_script( 'gfxbucket-bootstrap', get_template_directory_uri() . '/javascript/libraries/bootstrap.js', array('jquery'), '', true );
		wp_enqueue_script( 'gfxbucket-waypoints', get_template_directory_uri() . '/javascript/libraries/waypoints.min.js', array('jquery'), '', true );
		wp_enqueue_script( 'gfxbucket-featherlight-js', get_template_directory_uri() . '/javascript/libraries/featherlight.min.js', array('jquery'), '1.0', true );
		wp_enqueue_script( 'gfxbucket-featherlight-gallery-js', get_template_directory_uri() . '/javascript/libraries/featherlight.gallery.min.js', array('jquery'), '1.0', true );
		wp_enqueue_script( 'gfxbucket-theme-js', get_template_directory_uri() . '/javascript/theme.js', array('jquery'), '1.0', true );
		wp_localize_script( 'gfxbucket-theme-js', 'ajaxpagination', array('ajaxurl' => admin_url( 'admin-ajax.php' ) ));

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}

	/*
	 * Admin Styles And Scripts (CSS and JavaScript)
	 */

	function admin_style(  $hook ) {
		wp_enqueue_style( 'gfxbucket-admin-css', get_template_directory_uri() . '/css/admin-style.css' );
		wp_enqueue_style( 'gfxbucket-font-awesome', get_template_directory_uri() . '/css/min/font-awesome.min.css' );
		wp_enqueue_script( 'gfxbucket-admin-js', get_template_directory_uri() . '/javascript/admin.js' );
	}

	/*
	 * Editor Styles
	 */

	function editor_styles() {
		add_editor_style( get_template_directory_uri() . '/css/custom-editor-style.css' );

		$font_url = str_replace( ',', '%2C', 'http://fonts.googleapis.com/css?family=Lato:300,400,700,900&subset=latin,latin-ext' );
		add_editor_style( $font_url );
	}
}

$gfxbucket = new Gfxbucket();

/*
 * Remove Revolution Slider Notice
 */

if( function_exists( 'set_revslider_as_theme' ) ) {
	function gfxbucket_rm_rev_notice() {
		set_revslider_as_theme();
	}
	add_action( 'init', 'gfxbucket_rm_rev_notice' );
}