<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0"/>
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	
	<?php Gfxbucket::favicon(); ?>
	<?php Gfxbucket::styling(); ?>
	<?php Gfxbucket::mobile_icon(); ?>
	
	<script>
	  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
	  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
	  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
	  })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

	  ga('create', 'UA-40599254-1', 'auto');
	  ga('send', 'pageview');

	</script>

	<?php wp_head(); ?> >

</head>

<body <?php body_class(Gfxbucket::body_class()); ?>>

	<div class="site">
	
		<!-- SVGs -->
		<?php include('includes/svg-defs.html'); ?>
		<!-- /SVGs -->

		<?php
			/* Preloader, Header, Breadcrumbs and Page Cover */
			Gfxbucket::preloader();
			Gfxbucket::header();
			Gfxbucket::breadcrumbs();
			Gfxbucket::page_cover();
