<?php

/* Blog AJAX More */

add_action( 'wp_ajax_blog_more', 'gfxbucket_ajax_blog_more' );
add_action( 'wp_ajax_nopriv_blog_more', 'gfxbucket_ajax_blog_more' );

function gfxbucket_ajax_blog_more() {
	$page = $_POST['page'];
	$per_page = $_POST['per_page'];
	$categories = $_POST['categories'];
	$type = $_POST['type'];

    echo do_shortcode('[blog categories="' . $categories . '" per_page="' . $per_page . '" type="' . $type . '" page="' . $page . '" pagination="none" wrapper="off"]'); 
    die();
}

/* Portfolio AJAX More */

add_action( 'wp_ajax_portfolio_more', 'gfxbucket_ajax_portfolio_more' );
add_action( 'wp_ajax_nopriv_portfolio_more', 'gfxbucket_ajax_portfolio_more' );

function gfxbucket_ajax_portfolio_more() {
	$categories = $_POST['categories'];

	if( strpos($categories, '.') > -1 ) {
		$term = get_term_by('slug', substr($categories, 1), 'portfolio_category');
		$categories = $term->term_id;
	}

    echo do_shortcode('[portfolio order="' . $_POST['order'] . '" orderby="' . $_POST['orderby'] . '" type="' . $_POST['type'] . '" categories="' . $categories . '" per_page="' . $_POST['per_page'] . '" exclude="' . $_POST['exclude'] . '" load_more="no" filter="off" wrapper="off"]'); 
    die();
}

/* Portfolio AJAX (loading single posts) */

add_action( 'wp_ajax_portfolio_single', 'gfxbucket_ajax_portfolio_single' );
add_action( 'wp_ajax_nopriv_portfolio_single', 'gfxbucket_ajax_portfolio_single' );

function gfxbucket_ajax_portfolio_single() {
	$args = array(
		'post_type' => 'portfolio',
		'p'         => $_POST['id'],
	);

	$portfolio_posts = new WP_Query($args);

	if ( $portfolio_posts->have_posts() ) {
		while ( $portfolio_posts->have_posts() ) { $portfolio_posts->the_post();

	?>
	<style><?php echo siteorigin_panels_generate_css($_POST['id']); ?></style>
	<div class="portfolio-post-header-nav">
		<div class="row">
			<button class="porftolio-post-prev" title="<?php _e( 'Next Project', 'dropout' ); ?>">
				<svg>
					<use xlink:href="#shape-arrow-thin-left"></use>
				</svg>
			</button>
			<button class="porftolio-post-next" title="<?php _e( 'Previous Project', 'dropout' ); ?>">
				<svg>
					<use xlink:href="#shape-arrow-thin-right"></use>
				</svg>
			</button>	
			<button class="porftolio-post-close" title="<?php _e( 'Close Project', 'dropout' ); ?>">&times;</button>
			<div class="social">
				<strong><?php _e( 'Share the Project', 'dropout' ); ?>:</strong>
				<ul>
					<li><a href="http://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="fa fa-facebook"></i></a></li>
					<li><a href="https://twitter.com/intent/tweet?text=<?php the_title(); ?>&url=<?php the_permalink(); ?>"><i class="fa fa-twitter"></i></a></li>
					<li><a href="https://plus.google.com/share?url=<?php the_permalink(); ?>"><i class="fa fa-google-plus"></i></a></li>
					<li><a href="mailto:?subject=<?php the_title(); ?>&amp;body=<?php the_permalink(); ?>"><i class="fa fa-envelope"></i></a></li>
				</ul>
			</div>
		</div>
	</div>
	<?php
			Gfxbucket::portfolio_header(get_post_meta(get_the_id()), false);
			echo '<div class="portfolio-single-description container">';
			the_content();
			echo '</div>';
		}
	}
	wp_reset_postdata();

	?>

	<div class="portfolio-nav portfolio-nav-small">
		<div class="prev">
			<a href="#"><span><?php _e( 'Next Project', 'dropout' ); ?></span></a>
		</div>
		<div class="next">
			<a href="#"><span><?php _e( 'Previous Project', 'dropout' ); ?></span></a>
		</div>
	</div>

	<?php

    die();
}