<?php

/* Demo Content Import */

function gfxbucket_importer_init($demo_id) {
	require_once (dirname(__FILE__) . '/wordpress-importer.php');
    $wp_import = new WP_Import();
    $wp_import->import( dirname(__FILE__) . '/demo-content/' . $demo_id . '.xml' );

    update_option('gfxbucket_importer', '1');
}

function gfxbucket_importer_redux($demo_id) {
	global $reduxConfig;

	$file = dirname(__FILE__) . '/demo-content/redux/' . $demo_id . '.json';
	$file_contents = file_get_contents( $file );
	$options = json_decode($file_contents, true);

	foreach ($options as $key => $value) {
	    $reduxConfig->ReduxFramework->set($key, $value);
	}
}

/*$page = get_page_by_title('Contact');
$meta = get_post_meta($page->ID);
$panels_data = $meta['panels_data'][0];
$pos = strpos($panels_data, 'Gfxbucket_Contact_Form_7') + 28;
$form = get_page_by_title('Contact form 1', 'object', 'wpcf7_contact_form');*/

//var_dump($meta);

/*update_post_meta($page->ID, 'panels_data', substr($panels_data, 0, $pos) . $form->ID . substr($panels_data, $pos + 1));*/

function gfxbucket_importer_revslider($demo_id) {
	if ( is_plugin_active('revslider/revslider.php') ) {
		$sliders = array(1, 2, 3, 6, 7, 9, 10, 12, 14);

		if( $demo_id == 'demo-1' ||
		    $demo_id == 'demo-2' ||
		    $demo_id == 'demo-3' ||
		    $demo_id == 'demo-6' ||
		    $demo_id == 'demo-7' ||
		    $demo_id == 'demo-9' ||
		    $demo_id == 'demo-10' ||
		    $demo_id == 'demo-12' ||
		    $demo_id == 'demo-14' ) {

			ob_start();
	        $slider = new RevSlider();
	        $response = $slider->importSliderFromPost(true, true, dirname(__FILE__) . '/demo-content/revolution-slider/' . $demo_id . '.zip');
	        $output = ob_get_clean();

	        if( ! $response['success'] ) {
	            $message = $response['error'];
	            dmp('<p><strong>Error: ' . $message . '</strong></p>');
	        }	
		}
    }
}

function gfxbucket_importer_menu() {
	$term = get_term_by('name', 'Primary Menu', 'nav_menu');
	$locations = get_theme_mod('nav_menu_locations');
	$locations['primary'] = $term->term_id;
	set_theme_mod( 'nav_menu_locations', $locations );
}

function gfxbucket_importer_widgets($demo_id) {
	if( $demo_id == 'demo-5' ) {
		$sidebars = get_option('sidebars_widgets');

		/* Footer 1 */
		$text = array(
			'title'  => 'About Dropout',
			'text'   => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
			'filter' => true
		);
		$widgets = get_option('widget_text');
		$widgets[1] = $text;
		$sidebars['gfxbucket-footer-1'][0] = 'text-1';
		update_option('widget_text', $widgets);

		/* Footer 2 */
		$recent_posts = array(
			'title'     => 'Recent Posts',
			'number'    => 3,
			'show_date' => true
		);
		$widgets = get_option('widget_recent-posts');
		$widgets[1] = $recent_posts;
		$sidebars['gfxbucket-footer-2'][0] = 'recent-posts-1';
		update_option('widget_recent-posts', $widgets);

		/* Footer 3 */
		$recent_comments = array(
			'title'     => 'Recent Comments',
			'number'    => 5,
		);
		$widgets = get_option('widget_recent-comments');
		$widgets[1] = $recent_comments;
		$sidebars['gfxbucket-footer-3'][0] = 'recent-comments-1';
		update_option('widget_recent-comments', $widgets);

		/* Footer 4 */
		$search = array(
			'title' => 'Search',
		);
		$widgets = get_option('widget_search');
		$widgets[1] = $search;
		$sidebars['gfxbucket-footer-4'][0] = 'search-1';
		update_option('widget_search', $widgets);

		$tag_cloud = array(
			'title' => 'Tag Cloud',
		);
		$widgets = get_option('widget_tag_cloud');
		$widgets[1] = $tag_cloud;
		$sidebars['gfxbucket-footer-4'][1] = 'tag_cloud-1';
		update_option('widget_tag_cloud', $widgets);

		update_option('sidebars_widgets', $sidebars);
	} else if ( $demo_id == 'demo-13' ) {
		$social = array( 'title' => '' );

		$widgets = get_option('widget_Gfxbucket_Social');
		$widgets[1] = $social;

		$sidebars = get_option('sidebars_widgets');
		$sidebars['gfxbucket-footer-1'][0] = 'gfxbucket_social-1';

		update_option('widget_Gfxbucket_Social', $widgets);
		update_option('sidebars_widgets', $sidebars);
	} else {
		$recent_posts = array(
			'title'   => '',
		    'phone'   => '+353 (0) 123 456 78',
		    'email'   => 'hello@gfxbucket.com',
		    'address' => '121 King Street, Melbourne'
		);

		$widgets = get_option('widget_Gfxbucket_Contact_Info');
		$widgets[1] = $recent_posts;

		$sidebars = get_option('sidebars_widgets');
		$sidebars['gfxbucket-footer-1'][0] = 'gfxbucket_contact_info-1';

		update_option('widget_Gfxbucket_Contact_Info', $widgets);
		update_option('sidebars_widgets', $sidebars);
	}
}

function gfxbucket_importer_contact() {
	if( is_plugin_active('contact-form-7/wp-contact-form-7.php') ) {
		$args = array(
			'post_type' => 'wpcf7_contact_form'
		);

		$posts_array = get_posts( $args );

		foreach ( $posts_array as $post ) {
			wp_delete_post( $post->ID );
		}
		wp_reset_postdata();
	}
}

function gfxbucket_demo_content() {
	$demo_id = $_POST['demo_id'];

	/* Remove Contact Form 7 Forms */

	gfxbucket_importer_contact();

	/* WordPress Content */

	gfxbucket_importer_init($demo_id);

	/* Redux Framework Options */

	gfxbucket_importer_redux($demo_id);

	/* Revolution Slider */

	gfxbucket_importer_revslider($demo_id);

    /* Set menus */

    gfxbucket_importer_menu();

	/* Set Widget Areas */

	gfxbucket_importer_widgets($demo_id);

	/* Set Home Page */

	$page = get_page_by_title('Home Page');
	update_option('page_on_front', $page->ID);
	update_option('show_on_front', 'page');

	/* Set Blog Content To Excerpt */

	update_option('rss_use_excerpt', '1');

    die();
}

add_action( 'wp_ajax_demo_content', 'gfxbucket_demo_content' );
add_action( 'wp_ajax_nopriv_demo_content', 'gfxbucket_demo_content' );