<?php

/*
Widget Name: Recent Posts widget
Description: A customizable recent posts widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Recent_Posts extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-recent-posts',
			__('Gfxbucket Recent Posts', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays newest post of a certain category. Can have an option "More" link that links to the selected Posts page.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-pencil'
			),
			array(),
			array(
				'num_posts' => array(
					'type' => 'number',
					'label' => __( 'Number Of Posts', 'gfxbucket-shortcodes' ),
					'default' => '5'
				),
				'categories' => array(
					'type' => 'number',
					'label' => __( 'Categories', 'gfxbucket-shortcodes' ),
					'default' => '11'
				),
				'show_more_button' => array(
					'type' => 'checkbox',
					'label' => __( 'Show More Button', 'gfxbucket-shortcodes' ),
					'default' => true
				),
				'id' => array(
					'type' => 'text',
					'label' => __( 'ID (used for anchor navigation)', 'gfxbucket-shortcodes' ),
					'default' => ''
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-recent-posts', __FILE__, 'Gfxbucket_Recent_Posts');