<?php

add_action('admin_head', 'gfxbucket_add_tinymce_button');

function gfxbucket_add_tinymce_button() {
    global $typenow;

    // check user permissions
    if ( !current_user_can('edit_posts') && !current_user_can('edit_pages') ) {
        return;
    }

    add_filter("mce_external_plugins", "gfxbucket_add_tinymce_plugin");
    add_filter('mce_buttons', 'gfxbucket_register_my_tc_shortcodes');
}

function gfxbucket_add_tinymce_plugin($plugin_array) {
    $plugin_array['gfxbucket_tc_shortcodes'] = plugins_url( 'shortcodes.js', __FILE__ );
    return $plugin_array;
}

function gfxbucket_register_my_tc_shortcodes($buttons) {
   array_push($buttons, "gfxbucket_tc_shortcodes");
   return $buttons;
}

/**
 * Add styles/classes to the "Styles" drop-down
 */ 

function gfxbucket_mce_editor_buttons( $buttons ) {

    array_unshift( $buttons, 'styleselect' );
    return $buttons;
}
add_filter( 'mce_buttons_2', 'gfxbucket_mce_editor_buttons' );

function gfxbucket_mce_before( $settings ) {

    $style_formats = array(
        array(
            'title' => 'Mark Style 1',
            'inline' => 'mark',
            'classes' => 'mytest',
        ),
        array(
            'title' => 'Mark Style 2',
            'inline' => 'mark',
            'classes' => 'mytest style-2',
        ),
        array(
            'title' => 'Mark Style 3',
            'inline' => 'mark',
            'classes' => 'mytest style-3',
        ),
        array(
            'title' => 'Drop Caps Style 1',
            'inline' => 'span',
            'classes' => 'dropcaps',
        ),
        array(
            'title' => 'Drop Caps Style 2',
            'inline' => 'span',
            'classes' => 'dropcaps style-2',
        ),
        array(
            'title' => 'Blockquote',
            'block' => 'blockquote',
        ),
        array(
            'title' => 'Blockquote',
            'block' => 'blockquote',
            'classes' => 'style-2',
        ),
        array(
            'title' => 'Blockquote',
            'block' => 'blockquote',
            'classes' => 'style-3',
        )
    );

    $settings['style_formats'] = json_encode( $style_formats );

    return $settings;

}
add_filter( 'tiny_mce_before_init', 'gfxbucket_mce_before' );