<?php

global $accordion_id;
$accordion_id = 0;

function gfxbucket_accordion_func( $atts, $content ) {
	global $accordion_id, $accordion_item_id;
	$accordion_id++;
	$accordion_item_id = 0;

	return '<div class="panel-group" id="accordion-' . $accordion_id . '" role="tablist" aria-multiselectable="true">' . do_shortcode($content) . '</div>';
}
add_shortcode( 'accordion', 'gfxbucket_accordion_func' );

function gfxbucket_accordion_item_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'title'  => '',
        'text' 	 => '',
        'opened' => 'false'
	), $atts ));

	global $accordion_id, $accordion_item_id;
	$accordion_item_id++;

	$class = 'collapsed';
	$body_class = 'panel-collapse collapse';

	if( $opened == 'yes' || $opened == 'true' || $opened == '1' || $opened == 'on' ) {
		$body_class .= ' in';
		$class = '';
	}

	if( !$content ) {
		$content = $text;
	}

	return '<div class="panel panel-default">
		<div class="panel-heading" role="tab" id="heading-' . $accordion_id . '-' . $accordion_item_id . '">
			<h4 class="panel-title">
				<a class="' . $class . '" data-toggle="collapse" data-parent="#accordion-' . $accordion_id . '" href="#collapse-' . $accordion_id . '-' . $accordion_item_id . '" aria-expanded="true" aria-controls="collapse-' . $accordion_item_id . '">
					' . $title . '
				</a>
			</h4>
		</div>

		<div id="collapse-' . $accordion_id . '-' . $accordion_item_id . '" class="' . $body_class . '" role="tabpanel" aria-labelledby="heading-' . $accordion_id . '-' . $accordion_item_id . '">
			<div class="panel-body">' . $content . '</div>
		</div>
	</div>';
}
add_shortcode( 'accordion_item', 'gfxbucket_accordion_item_func' );