<?php

function icon_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'title' => '',
		'text'  => '',
		'icon'  => '',
		'color' => '',
		'image' => '',
		'style' => 'style-1'
	), $atts ));
	
	$icon_include = '';
	$class = 'icon';

	$icon = str_replace('fontawesome', 'fa', $icon);
	$icon = str_replace('typicons', 'typcn', $icon);
	$icon = str_replace('genericons', 'genericon', $icon);

	if( $image ) {
		$icon_include = '<img src="' . $image . '" alt="">';
	}	
	else if( $icon ) {
		if ( strpos($icon, 'fa') > -1 ) {
			$icon_include = '<i class="fa ' . $icon . '"></i>';
		} else if ( strpos($icon, 'typcn') > -1 ) {
			$icon_include = '<i class="typcn ' . $icon . '"></i>';
			wp_enqueue_style( 'gfxbucket-typicons', plugins_url( 'css/min/typicons.min.css', __FILE__ ) );
		} else if ( strpos($icon, 'elegantline') > -1 ) {
			$icon_include = '<i class="elegantline ' . $icon . '"></i>';
			wp_enqueue_style( 'gfxbucket-elegantline', plugins_url( 'css/min/elegantline.min.css', __FILE__ ) );
		} else if ( strpos($icon, 'genericon') > -1 ) {
			$icon_include = '<i class="genericon ' . $icon . '"></i>';
			wp_enqueue_style( 'gfxbucket-genericons', plugins_url( 'css/min/genericons.min.css', __FILE__ ) );
		} else if ( strpos($icon, 'icomoon') > -1 ) {
			$icon_include = '<i class="icomoon ' . $icon . '"></i>';
			wp_enqueue_style( 'gfxbucket-icomoon', plugins_url( 'css/min/icomoon.min.css', __FILE__ ) );
		}
	}

	if( $style == 'style-2' ) {
		$class .= ' style-2';
	}

	if( $color ) {
		$color = ' style="color: ' . $color . '"';
	}

	if( $title || $text ) {
		return '<div class="' . $class . '">
			<div class="icon-image"' . $color . '>' . $icon_include . '</div>
			<div class="icon-content">
				<h4>' . $title . '</h4>
				<p>' . $text . '</p>
			</div>
		</div>';
	} else {
		return $icon_include;
	}
}
add_shortcode( 'icon', 'icon_func' );