<?php

function pricing_table_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'title' => 'Pricing Table Title',
		'price' => '0.00',
		'currency' => '$',
		'currency_position' => 'left',
		'link' => '#',
		'link_text' => 'Choose Plan',
	), $atts ));

	if( $link_text ) {
		$link_text = '<a href="' . $link . '" class="btn btn-md">' . $link_text . '</a>';
	}

	return '<div class="pricing-table">
		<h3 class="pricing-title">' . $title . '</h3>
		<h4 class="pricing-price"><span>' . $currency . '</span> ' . $price . '</h4>
		<ul>' . do_shortcode($content) . '</ul>
		' . $link_text . '
	</div>';
}
add_shortcode( 'pricing_table', 'pricing_table_func' );


function pricing_table_row_func( $atts, $content ) {
	extract(shortcode_atts( array(), $atts ));

	return '<li>' . $content . '</li>';
}
add_shortcode( 'pricing_table_row', 'pricing_table_row_func' );