<?php

function gfxbucket_progress_bar_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'title'    => '',
		'subtitle' => '',
		'value'    => 50,
		'max'      => 100
	), $atts ));

	$value = intval($value);
	$max   = intval($max);

	ob_start();
	?>
	<div class="progress-wrap">
		<h5 class="progress-title"><?php echo $title; ?></h5>
		<div class="progress-meta">
			<?php if ( $subtitle != '' ): ?><div class="progress-content"><?php echo $subtitle; ?></div><?php endif; ?>
			<span class="progress-number"><?php echo $value; ?>%</span>
		</div>
		<div class="progress"><div class="progress-bar" role="progressbar" aria-valuenow="<?php echo $value/$max*100; ?>" aria-valuemin="0" aria-valuemax="<?php echo $max; ?>" style="width: <?php echo $value/$max*100; ?>%;"></div></div>
	</div>
	<?php

	$return = ob_get_contents();
	ob_end_clean();

	return $return;
}
add_shortcode( 'progress_bar', 'gfxbucket_progress_bar_func' );