<?php

function section_fs_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'scrollbar' => '',
		'navigation' => '',
	), $atts ));

	$attributes = '';

	if( $scrollbar == '1' ) {
		$attributes .= ' data-scroll="on"';
	}

	if( $navigation == '1' ) {
		$attributes .= ' data-nav="on"';
	}

	wp_enqueue_style(  'gfxbucket-onepage-scroll-css', plugins_url( 'css/jquery.fullPage.css', __FILE__ ) );
	wp_enqueue_script( 'gfxbucket-onepage-scroll', plugins_url( 'javascript/jquery.fullPage.min.js', __FILE__ ), array('jquery'), '', true );

	return '<div class="section-fs-container"' . $attributes . '>' . do_shortcode($content) . '</div>';
}
add_shortcode( 'section_fs', 'section_fs_func' );

global $section_fs_counter;
$section_fs_counter = 0;

/* Simple */

function section_fs_simple_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'align'      => 'left',
		'title'      => '',
		'text'       => '',
		'image'      => '',
		'link'       => '',
		'link_text'  => __( 'Find Out More', 'gfxbucket-shortcodes' ),
		'new_window' => 'false',
		'animate'    => 'no',
		'slug'       => '',
		'tooltip'    => '',
	), $atts ));

	$button = '';
	$animate_class = '';

	global $section_fs_counter;
	$section_fs_counter++;

	$section_anchor = 'section-' . $section_fs_counter;

	if( $slug ) {
		$section_anchor = $slug;
	}

	// If animation is set

	if( $animate == 'yes' || $animate == '1' ) {
		$animate_class = ' section-fs-image-zoom';
	}

	// If set, wrap target attribute with HTML target attribute

	$target = '';
	if( $new_window == 'true' || $new_window == '1' ) {
		$target = ' target="_blank"';
	}

	// Check if link is set

	if( $link ) {
		$button = '<a class="btn btn-lg" href="' . $link . '"' . $target . '">' . $link_text . '</a>';
	}

	// Return shortcode

	return '<section data-anchor="' . $section_anchor . '" data-tooltip="' . $tooltip . '" class="section-fs">
		<div class="section-fs-image' . $animate_class . '" style="background-image: url(' . $image . ');"></div>

		<div class="container">
			<div class="section-fs-content section-fs-content-' . $align . '">
				<h2 class="text-uppercase">' . $title . '</h2>
				<p>' . $text . '</p>
				' . $button . '
			</div>
		</div>
	</section>';
}
add_shortcode( 'section_fs_simple', 'section_fs_simple_func' );

/* Instagram */

function section_fs_instagram_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'id' => '',
		'slug'    => '',
		'tooltip' => '',
	), $atts ));

	global $section_fs_counter;
	$section_fs_counter++;

	$section_anchor = 'section-' . $section_fs_counter;

	if( $slug ) {
		$section_anchor = $slug;
	}

	return '<section data-anchor="' . $section_anchor . '" data-tooltip="' . $tooltip .  '" class="section-fs">
		<div class="section-fs-image' . $animate_class . '" style="background-image: url(' . $image . ');">
			' . do_shortcode('[instagram fs="on"]' . $id . '[/instagram]') . '
		</div>
	</section>';
}
add_shortcode( 'section_fs_instagram', 'section_fs_instagram_func' );

/* Twitter */

function section_fs_twitter_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'username' => '',
		'slug'    => '',
		'tooltip' => '',
	), $atts ));

	global $section_fs_counter;
	$section_fs_counter++;

	$section_anchor = 'section-' . $section_fs_counter;

	if( $slug ) {
		$section_anchor = $slug;
	}

	return '<section data-anchor="' . $section_anchor . '" data-tooltip="' . $tooltip .  '" class="section-fs">
		<div class="section-fs-image">
			' . do_shortcode('[twitter fs="on"]' . $id . '[/twitter]') . '
		</div>
	</section>';
}
add_shortcode( 'section_fs_twitter', 'section_fs_twitter_func' );

/* Contact Form 7 */

function section_fs_contact_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'id'      => '',
		'image'   => '',
		'animate' => 'no',
		'slug'    => '',
		'tooltip' => '',
		'title'   => '',
	), $atts ));

	global $section_fs_counter;
	$section_fs_counter++;

	$section_anchor = 'section-' . $section_fs_counter;

	if( $slug ) {
		$section_anchor = $slug;
	}

	if( $title ) {
		$title = '<h2 class="text-uppercase text-center">' . $title . '</h2>';
	}

	return '<section data-anchor="' . $section_anchor . '" data-tooltip="' . $tooltip .  '" class="section-fs">
		<div class="section-fs-image' . $animate_class . '" style="background-image: url(' . $image . ');"></div>

		<div class="container">
			<div class="col-md-8 section-fs-content-center">
				' . $title . '
				' . do_shortcode('[contact-form-7 id="' . $id . '"]') . '
			</div>
		</div>
	</section>';
}
add_shortcode( 'section_fs_contact', 'section_fs_contact_func' );

/* Advanced Text */

function section_fs_advanced_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'image'       => '',
		'animate'     => 'no',
		'box_align_x' => 'left',
		'box_align_y' => 'center',
		'align'       => 'left',
		'slug'        => '',
		'tooltip'     => '',
	), $atts ));

	global $section_fs_counter;
	$section_fs_counter++;

	$section_anchor = 'section-' . $section_fs_counter;

	if( $slug ) {
		$section_anchor = $slug;
	}

	$class = 'fs-x-' . $box_align_x . ' fs-y-' . $box_align_y;

	// If animation is set

	if( $animate == 'yes' || $animate == '1' ) {
		$animate_class = ' section-fs-image-zoom';
	}

	return '<section data-anchor="' . $section_anchor . '" data-tooltip="' . $tooltip . '" class="section-fs">
		<div class="section-fs-image' . $animate_class . '" style="background-image: url(' . $image . ');"></div>

		<div class="container">
			<div class="section-fs-content section-fs-content-advanced ' . $class . '"  style="text-align: ' . $align . ';">
				' . $content . '
			</div>
		</div>
	</section>';
}
add_shortcode( 'section_fs_advanced', 'section_fs_advanced_func' );