<?php

function team_func( $atts, $content ) {
	extract(shortcode_atts( array(), $atts ));

	return '<div class="team"><div class="container"><div class="row">' . do_shortcode($content) . '</div></div></div>';
}
add_shortcode( 'team', 'team_func' );

function team_member_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'name'  => '',
		'title' => '',
		'image' => ''
	), $atts ));

	if( is_numeric($image) ) {
		$image = wp_get_attachment_image_src($image, 'full');
		$image = $image[0];
	}

	return '<article class="member col-md-4 col-sm-6">
		<div class="member-image">
		<img src="' . $image . '" alt="' . $name . '">
		</div>
		<h3>' . $name . '</h3>
		<em>' . $title . '</em>
		<ul class="team-social">' . $content . '</ul>
	</article>';
}
add_shortcode( 'team_member', 'team_member_func' );


function team_member_social_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'icon' => '',
		'url'  => '#'
	), $atts ));

	return '<li><a href="' . $url . '" target="_blank">' . do_shortcode('[icon icon="' . $icon . '"]') . '</a></li>';
}
add_shortcode( 'team_member_social', 'team_member_social_func' );