<?php

/*
Widget Name: Accordion widget
Description: A customizable accordion widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Accordion extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-accordion',
			__('Gfxbucket Accordion', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays collapsible content panels for presenting information in a limited amount of space.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-reorder'
			),
			array(),
			array(
				'accordion' => array(
					'type' => 'repeater',
					'label' => __( 'Accordion Items' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'Accordion Item', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='accordion']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(
						'title' => array(
							'type' => 'text',
							'label' => __( 'Title', 'gfxbucket-shortcodes' )
						),
						'text' => array(
							'type' => 'tinymce',
							'label' => __( 'Text', 'gfxbucket-shortcodes' )
						),
						'opened' => array(
							'type' => 'checkbox',
							'label' => __( 'Opened view', 'gfxbucket-shortcodes' ),
							'default' => false
						),
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-accordion', __FILE__, 'Gfxbucket_Accordion');