<?php

/*
Widget Name: Contact Form 7 widget
Description: A customizable contact form 7 widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Contact_Form_7 extends SiteOrigin_Widget {
	function __construct() {
		$wpcf7_array = array();

		$args = array(
			'post_type' => 'wpcf7_contact_form',
		);

		$wpcf7 = get_posts($args);

		foreach( $wpcf7 as $post ) { setup_postdata( $post );
			$wpcf7_array[$post->ID] = $post->post_title;
		} wp_reset_postdata();

		parent::__construct(
			'gfxbucket-contact-form-7',
			__('Gfxbucket Contact Form 7', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays a Contact Form 7 element.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-comment-o'
			),
			array(),
			array(
				'contact_form' => array(
					'type' => 'select',
					'label' => __( 'Select contact form', 'gfxbucket-shortcodes' ),
					'default' => '',
					'options' => $wpcf7_array
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-contact-form-7', __FILE__, 'Gfxbucket_Contact_Form_7');