<?php

/*
Widget Name: Icon widget
Description: A customizable icon widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Icon extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-icon',
			__('Gfxbucket Icon', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays an icon with text. Has an option of different styles.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-puzzle-piece'
			),
			array(),
			array(
				'title' => array(
					'type' => 'text',
					'label' => __( 'Title', 'gfxbucket-shortcodes' ),
					'default' => ''
				),
				'text' => array(
					'type' => 'text',
					'label' => __( 'Text', 'gfxbucket-shortcodes' ),
					'default' => ''
				),
				'style' => array(
					'type' => 'select',
					'label' => __( 'Style', 'gfxbucket-shortcodes' ),
					'default' => 'style-1',
					'options' => array(
						'style-1' => __( 'Style 1', 'gfxbucket-shortcodes' ),
						'style-2' => __( 'Style 2', 'gfxbucket-shortcodes' ),
					)
				),
				'icon' => array(
					'type' => 'icon',
					'label' => __('Select an icon', 'gfxbucket-shortcodes'),
				),
				'color' => array(
					'type' => 'color',
					'label' => __( 'Choose a color for the icon', 'gfxbucket-shortcodes' ),
					'default' => '#dbdbdb'
				),
				'image' => array(
					'type' => 'media',
					'label' => __( 'Icon image', 'gfxbucket-shortcodes' ),
					'choose' => __( 'Choose image', 'gfxbucket-shortcodes' ),
					'update' => __( 'Set image', 'gfxbucket-shortcodes' ),
					'description'   => __( 'Use your own icon image.', 'gfxbucket-shortcodes' ),
					'library' => 'image',
					'fallback' => true,
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-icon', __FILE__, 'Gfxbucket_Icon');