<?php

/*
Widget Name: More widget
Description: A customizable button widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_More extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-more',
			__('Gfxbucket More', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays a different styles link element. Useful for redirecting to other pages.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-caret-square-o-down'
			),
			array(),
			array(
				'text' => array(
					'type' => 'text',
					'label' => __( 'Text', 'gfxbucket-shortcodes' ),
					'default' => 'Text'
				),
				'url' => array(
					'type' => 'text',
					'label' => __( 'Destination URL', 'gfxbucket-shortcodes' ),
					'default' => '#'
				),
				'new_window' => array(
					'type' => 'checkbox',
					'label' => __( 'Open in a new window', 'gfxbucket-shortcodes' ),
					'default' => false
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-more', __FILE__, 'Gfxbucket_More');