<?php

/*
Widget Name: Featured Portfolio Posts widget
Description: A customizable clients widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Featured_Portfolio_Posts extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-featured-portfolio-posts',
			__('Gfxbucket Featured Portfolio Posts', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays inserted featured portfolio posts in a carousel.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-camera'
			),
			array(),
			array(
				'item' => array(
					'type' => 'repeater',
					'label' => __( 'Item' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'Item', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='item']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(
						'title' => array(
							'type' => 'text',
							'label' => __( 'Title', 'gfxbucket-shortcodes' )
						),
						'image' => array(
							'type' => 'media',
							'label' => __( 'Featured Image', 'gfxbucket-shortcodes' ),
							'choose' => __( 'Choose image', 'gfxbucket-shortcodes' ),
							'update' => __( 'Set image', 'gfxbucket-shortcodes' ),
							'library' => 'image',
							'fallback' => true,
						),
						'text_left' => array(
							'type' => 'textarea',
							'label' => __( 'Text left', 'gfxbucket-shortcodes' ),
							'default' => ''
						),
						'text_right' => array(
							'type' => 'textarea',
							'label' => __( 'Text right', 'gfxbucket-shortcodes' ),
							'default' => ''
						),
						'url' => array(
							'type' => 'text',
							'label' => __( 'Destination URL', 'gfxbucket-shortcodes' )
						),
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-featured-portfolio-posts', __FILE__, 'Gfxbucket_Featured_Portfolio_Posts');