<?php

/*
Widget Name: Section Full Screen widget
Description: A customizable full screen section widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Section_Fs extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-section-fs',
			__('Gfxbucket Section Full Screen', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays full screen sections with background images. Uses section scrolling.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-external-link'
			),
			array(),
			array(
				'scrollbar' => array(
					'type' => 'checkbox',
					'label' => __( 'Show scrollbar?', 'gfxbucket-shortcodes' ),
					'default' => false
				),
				'navigation' => array(
					'type' => 'checkbox',
					'label' => __( 'Show side navigation?', 'gfxbucket-shortcodes' ),
					'default' => true
				),
				'section_items' => array(
					'type' => 'repeater',
					'label' => __( 'Sections' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'Single Section', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='section_fs']",
					),
					'fields' => array(
						'form_type' => array(
							'type' => 'select',
							'label' => __( 'Type', 'gfxbucket-shortcodes' ),
							'default' => 'simple',
						    'state_emitter' => array(
						        'callback' => 'select',
						        'args' => array( 'form_type' )
						    ),
							'options' => array(
								'simple'    => __( 'Simple text', 'gfxbucket-shortcodes' ),
								'instagram' => __( 'Instagram', 'gfxbucket-shortcodes' ),
								'twitter'   => __( 'Twitter', 'gfxbucket-shortcodes' ),
								'contact'   => __( 'Contact Form', 'gfxbucket-shortcodes' ),
								'advanced'  => __( 'Advanced Text', 'gfxbucket-shortcodes' ),
							)
						),
						'tooltip' => array(
							'type' => 'text',
							'label' => __( 'Tooltip', 'gfxbucket-shortcodes' )
						),
						'slug' => array(
							'type' => 'text',
							'label' => __( 'Slug', 'gfxbucket-shortcodes' )
						),
						'instagram' => array(
							'type' => 'section',
							'label' => __( 'Instagram' , 'gfxbucket-shortcodes' ),
							'hide' => false,
							'state_handler' => array(
						        'form_type[instagram]' => array('show'),
						        '_else[form_type]' => array( 'hide' ),
						    ),
							'fields' => array(
								'instagram_id' => array(
									'type' => 'text',
									'label' => __( 'Instagram ID', 'gfxbucket-shortcodes' ),
								),
							)
						),
						'twitter' => array(
							'type' => 'section',
							'label' => __( 'Twitter' , 'gfxbucket-shortcodes' ),
							'hide' => false,
							'state_handler' => array(
						        'form_type[twitter]' => array('show'),
						        '_else[form_type]' => array( 'hide' ),
						    ),
							'fields' => array(
								'instagram_username' => array(
									'type' => 'text',
									'label' => __( 'Twitter username', 'gfxbucket-shortcodes' ),
								),
							)
						),
						'contact' => array(
							'type' => 'section',
							'label' => __( 'Contact' , 'gfxbucket-shortcodes' ),
							'hide' => false,
							'state_handler' => array(
						        'form_type[contact]' => array('show'),
						        '_else[form_type]' => array( 'hide' ),
						    ),
							'fields' => array(
								'title' => array(
									'type' => 'text',
									'label' => __( 'Title', 'gfxbucket-shortcodes' ),
								),
								'contact_id' => array(
									'type' => 'text',
									'label' => __( 'Contact Form 7 ID', 'gfxbucket-shortcodes' ),
								),
								'image' => array(
									'type' => 'media',
									'label' => __( 'Background Image', 'gfxbucket-shortcodes' ),
									'choose' => __( 'Choose image', 'gfxbucket-shortcodes' ),
									'update' => __( 'Set image', 'gfxbucket-shortcodes' ),
									'library' => 'image',
									'fallback' => true
								),
								'animate' => array(
									'type' => 'checkbox',
									'label' => __( 'Animate background image?', 'gfxbucket-shortcodes' ),
									'default' => false
								),
							)
						),
						'simple' => array(
							'type' => 'section',
							'label' => __( 'Simple text' , 'gfxbucket-shortcodes' ),
							'hide' => false,
							'state_handler' => array(
						        'form_type[simple]' => array('show'),
						        '_else[form_type]' => array( 'hide' ),
						    ),
							'fields' => array(
								'image' => array(
									'type' => 'media',
									'label' => __( 'Background Image', 'gfxbucket-shortcodes' ),
									'choose' => __( 'Choose image', 'gfxbucket-shortcodes' ),
									'update' => __( 'Set image', 'gfxbucket-shortcodes' ),
									'library' => 'image',
									'fallback' => true
								),
								'animate' => array(
									'type' => 'checkbox',
									'label' => __( 'Animate background image?', 'gfxbucket-shortcodes' ),
									'default' => false
								),
								'title' => array(
									'type' => 'text',
									'label' => __( 'Title', 'gfxbucket-shortcodes' )
								),
								'text' => array(
									'type' => 'text',
									'label' => __( 'Text', 'gfxbucket-shortcodes' )
								),
								'link' => array(
									'type'  => 'text',
									'label' => __( 'Link', 'gfxbucket-shortcodes' )
								),
								'link_text' => array(
									'type'  => 'text',
									'label' => __( 'Link Text', 'gfxbucket-shortcodes' )
								),
								'new_window' => array(
									'type' => 'checkbox',
									'label' => __( 'Open in a new window', 'gfxbucket-shortcodes' ),
									'default' => false
								),
								'align' => array(
									'type' => 'select',
									'label' => __( 'Align', 'gfxbucket-shortcodes' ),
									'default' => 'left',
									'options' => array(
										'left'    => __( 'Left', 'gfxbucket-shortcodes' ),
										'right' => __( 'Right', 'gfxbucket-shortcodes' ),
										'center'   => __( 'Center', 'gfxbucket-shortcodes' ),
									)
								),
							),
						),
						'advanced' => array(
							'type' => 'section',
							'label' => __( 'Advanced text' , 'gfxbucket-shortcodes' ),
							'hide' => false,
							'state_handler' => array(
						        'form_type[advanced]' => array('show'),
						        '_else[form_type]' => array( 'hide' ),
						    ),
							'fields' => array(
								'content' => array(
									'type' => 'tinymce',
									'label' => __( 'Content', 'gfxbucket-shortcodes' )
								),
								'image' => array(
									'type' => 'media',
									'label' => __( 'Background Image', 'gfxbucket-shortcodes' ),
									'choose' => __( 'Choose image', 'gfxbucket-shortcodes' ),
									'update' => __( 'Set image', 'gfxbucket-shortcodes' ),
									'library' => 'image',
									'fallback' => true
								),
								'animate' => array(
									'type' => 'checkbox',
									'label' => __( 'Animate background image?', 'gfxbucket-shortcodes' ),
									'default' => false
								),
								'box_align_x' => array(
									'type' => 'select',
									'label' => __( 'Box align - horizontal', 'gfxbucket-shortcodes' ),
									'default' => 'left',
									'options' => array(
										'left'    => __( 'Left', 'gfxbucket-shortcodes' ),
										'right' => __( 'Right', 'gfxbucket-shortcodes' ),
										'center'   => __( 'Center', 'gfxbucket-shortcodes' ),
									)
								),
								'box_align_y' => array(
									'type' => 'select',
									'label' => __( 'Box align - vertical', 'gfxbucket-shortcodes' ),
									'default' => 'center',
									'options' => array(
										'top'    => __( 'Top', 'gfxbucket-shortcodes' ),
										'bottom' => __( 'Bottom', 'gfxbucket-shortcodes' ),
										'center'   => __( 'Center', 'gfxbucket-shortcodes' ),
									)
								),
								'align' => array(
									'type' => 'select',
									'label' => __( 'Text align', 'gfxbucket-shortcodes' ),
									'default' => 'left',
									'options' => array(
										'left'    => __( 'Left', 'gfxbucket-shortcodes' ),
										'right' => __( 'Right', 'gfxbucket-shortcodes' ),
										'center'   => __( 'Center', 'gfxbucket-shortcodes' ),
									)
								),
							),
						)
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-section-fs', __FILE__, 'Gfxbucket_Section_Fs');