<?php

/*
Widget Name: Testimonials widget
Description: A customizable testimonials widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Testimonials extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-testimonials',
			__('Gfxbucket Testimonials', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays an image, comment and optional rating in a carousel.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-comments-o'
			),
			array(),
			array(
				'list' => array(
					'type' => 'repeater',
					'label' => __( 'Tetimonials Item' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'Tetimonials Item', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='testimonials-item']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(
						'image' => array(
							'type' => 'media',
							'label' => __( 'Image', 'gfxbucket-shortcodes' ),
							'choose' => __( 'Choose image', 'gfxbucket-shortcodes' ),
							'update' => __( 'Set image', 'gfxbucket-shortcodes' ),
							'library' => 'image',
							'fallback' => true,
						),
						'name' => array(
							'type'  => 'text',
							'label' => __( 'Name', 'gfxbucket-shortcodes' )
						),
						'title' => array(
							'type'  => 'text',
							'label' => __( 'Title', 'gfxbucket-shortcodes' )
						),
						/*'rating' => array(
							'type' => 'slider',
							'label' => __( 'Rating', 'gfxbucket-shortcodes' ),
							'default' => 5,
							'min' => 0,
							'max' => 5,
							'integer' => true
						),*/
						'rating' => array(
							'type' => 'select',
							'label' => __( 'Rating', 'gfxbucket-shortcodes' ),
							'default' => '5',
							'options' => array(
								'1' => __( '1 star', 'gfxbucket-shortcodes' ),
								'2' => __( '2 stars', 'gfxbucket-shortcodes' ),
								'3' => __( '3 stars', 'gfxbucket-shortcodes' ),
								'4' => __( '4 stars', 'gfxbucket-shortcodes' ),
								'5' => __( '5 stars', 'gfxbucket-shortcodes' ),
							)
						),
						'text' => array(
							'type' => 'textarea',
							'label' => __( 'Text', 'gfxbucket-shortcodes' )
						),
						'link' => array(
							'type'  => 'text',
							'label' => __( 'Link', 'gfxbucket-shortcodes' )
						),
						'link_text' => array(
							'type'  => 'text',
							'label' => __( 'Link Text', 'gfxbucket-shortcodes' )
						),
						'new_window' => array(
							'type' => 'checkbox',
							'label' => __( 'Open in a new window', 'gfxbucket-shortcodes' ),
							'default' => false
						)
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-testimonials', __FILE__, 'Gfxbucket_Testimonials');