<?php
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php if ( have_comments() ) : ?>

		<ol class="comment-list">
			<?php
				wp_list_comments( array(
					'style'       => 'ol',
					'short_ping'  => true,
					'avatar_size' => 56,
					'callback'    => 'gfxbucket_comment'
				) );
			?>
		</ol><!-- .comment-list -->

		<div class="navigation">
			<?php paginate_comments_links(); ?> 
		</div>
 
	<?php endif; // have_comments() ?>

	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php _e( 'Comments are closed.', 'dropout' ); ?></p>
	<?php endif; ?>

	<?php
		$commenter = wp_get_current_commenter();
		$req = get_option( 'require_name_email' );
		$aria_req = ( $req ? " aria-required='true'" : '' );

		$fields =  array(

		  'author' =>
		    '<div class="row"><p class="comment-form-author col-md-4"><label for="author">' . __( 'Name', 'dropout' ) . '</label>
		    <input placeholder="' . __( 'Name', 'dropout' ) . ( $req ? '*' : '' ) . '" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .
		    '" size="30"' . $aria_req . ' /></p>',

		  'email' =>
		    '<p class="comment-form-email col-md-4"><label for="email">' . __( 'Email', 'dropout' ) . '</label> 
		    <input placeholder="' . __( 'Email', 'dropout' ) . ( $req ? '*' : '' ) . '" id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .
		    '" size="30"' . $aria_req . ' /></p>',

		  'url' =>
		    '<p class="comment-form-url col-md-4"><label for="url">' . __( 'Website', 'dropout' ) . '</label>' .
		    '<input placeholder="' . __( 'Website', 'dropout' ) . '" id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) .
		    '" size="30"' . $aria_req . ' /></p></div>',

		);

		$comments_args = array(
			'class_submit'        => 'btn btn-md',
			'comment_notes_after' => '',
			'fields' => apply_filters( 'comment_form_default_fields', $fields )
		);

		comment_form($comments_args);
	?>

</div><!-- .comments-area -->
