<?php
/**
 * Redux Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * Redux Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Redux Framework. If not, see <http://www.gnu.org/licenses/>.
 *
 * @package     ReduxFramework
 * @author      Dovy Paukstys
 * @version     3.1.5
 */

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

// Don't duplicate me!
if( !class_exists( 'ReduxFramework_demo_import' ) ) {

    /**
     * Main ReduxFramework_demo_import class
     *
     * @since       1.0.0
     */
    class ReduxFramework_demo_import extends ReduxFramework {
    
        /**
         * Field Constructor.
         *
         * Required - must call the parent constructor, then assign field and value to vars, and obviously call the render field function
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        function __construct( $field = array(), $value ='', $parent ) {
        
            
            $this->parent = $parent;
            $this->field = $field;
            $this->value = $value;

            if ( empty( $this->extension_dir ) ) {
                $this->extension_dir = trailingslashit( str_replace( '\\', '/', dirname( __FILE__ ) ) );
                $this->extension_url = site_url( str_replace( trailingslashit( str_replace( '\\', '/', ABSPATH ) ), '', $this->extension_dir ) );
            }    

            // Set default args for this field to avoid bad indexes. Change this to anything you use.
            $defaults = array(
                'options'           => array(),
                'stylesheet'        => '',
                'output'            => true,
                'enqueue'           => true,
                'enqueue_frontend'  => true
            );
            $this->field = wp_parse_args( $this->field, $defaults );            
        
        }

        /**
         * Field Render Function.
         *
         * Takes the vars and outputs the HTML for the field in the settings
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        public function render() {
        
            // HTML output goes here
            ?>
            <div id="gfxbucket-import"<?php if( get_option('gfxbucket_importer') ) { echo ' data-warning="' . __( 'You have already imported demo content on your site. Importing content multiple times is not recommended and may cause some errors. Are you sure you want to continue?', 'dropout' ) . '"'; } ?>>
                <div class="import-action">
                    <button id="demo-1">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-1.jpg" alt="One Page">
                        <h4>One Page</h4>
                    </button>
                    <button id="demo-2">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-2.jpg" alt="Parallax">
                        <h4>Parallax</h4>
                    </button>
                    <button id="demo-3">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-3.jpg" alt="Creative">
                        <h4>Creative</h4>
                    </button>
                    <button id="demo-14">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-14.jpg" alt="Minimal with parallax ">
                        <h4>Minimal with parallax </h4>
                    </button>
                    <button id="demo-13">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-13.jpg" alt="Section scrolling ">
                        <h4>Section scrolling </h4>
                    </button>
                    <button id="demo-4">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-4.jpg" alt="Portfolio">
                        <h4>Portfolio</h4>
                    </button>
                    <button id="demo-5">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-5.jpg" alt="Full Screen Portfolio">
                        <h4>Full Screen Portfolio</h4>
                    </button>
                    <button id="demo-6">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-6.jpg" alt="Sidebar with one page">
                        <h4>Sidebar with one page</h4>
                    </button>
                    <button id="demo-7">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-7.jpg" alt="Super Minimal">
                        <h4>Super Minimal</h4>
                    </button>
                    <button id="demo-8">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-8.jpg" alt="Sidebar with portfolio">
                        <h4>Sidebar with portfolio</h4>
                    </button>
                    <button id="demo-9">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-9.jpg" alt="Sidebar with slider">
                        <h4>Sidebar with slider</h4>
                    </button>
                    <button id="demo-10">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-10.jpg" alt="Video Slider">
                        <h4>Video Slider</h4>
                    </button>
                    <button id="demo-11">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-11.jpg" alt="Blog Home">
                        <h4>Blog Home</h4>
                    </button>
                    <button id="demo-12">
                        <img src="<?php echo get_template_directory_uri(); ?>/images/theme-options/demos/demo-12.jpg" alt="Boxed Layout">
                        <h4>Boxed Layout</h4>
                    </button>
                </div>
                <div class="import-status" id="import-status">
                    <div class="import-progress"><div class="import-spinner"></div><?php _e( 'Installing demo content. Please wait.', 'dropout' ); ?></div>
                    <div class="import-done"></div>
                </div>
            </div>
            <?php
        }
    
        /**
         * Enqueue Function.
         *
         * If this field requires any scripts, or css define this function and register/enqueue the scripts/css
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        public function enqueue() {

            $extension = ReduxFramework_extension_demo_import::getInstance();
        
            wp_enqueue_script(
                'redux-field-icon-select-js', 
                $this->extension_url . 'field_demo_import.js', 
                array( 'jquery' ),
                time(),
                true
            );

            wp_localize_script( 'redux-field-icon-select-js', 'dummy', array('ajaxurl' => admin_url( 'admin-ajax.php' ) ));

            wp_enqueue_style(
                'redux-field-icon-select-css', 
                $this->extension_url . 'field_demo_import.css',
                time(),
                true
            );
        
        }
        
        /**
         * Output Function.
         *
         * Used to enqueue to the front-end
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */        
        public function output() {
            if ( $this->field['enqueue_frontend'] ) { }
        }        
        
    }
}
