<?php
/**
 * Template for displaying pages.
 */

get_header(); ?>

<?php
$class = ' col-md-12';
$sidebar_left = false;
$sidebar_right = false;

global $gfxbucket_options;

$meta = get_post_meta(get_the_id());

/* Global Options */

if( isset($gfxbucket_options['gfxbucket-page-sidebar']) ) {
	switch( $gfxbucket_options['gfxbucket-page-sidebar'] ) {
		case '2': $sidebar_left = true; $class = ' col-md-8 col-md-offset-1'; break;
		case '3': $sidebar_right = true; $class = ' col-md-8'; break;
	}
}

/* Post Options */

if( isset($meta['_gfxbucket_sidebar_status']) ) {
	switch( $meta['_gfxbucket_sidebar_status'][0] ) {
		case '1': $sidebar_left = true; $sidebar_right = false; $class = ' col-md-8 col-md-offset-1'; break;
		case '2': $sidebar_left = false; $sidebar_right = true; $class = ' col-md-8'; break;
		case '3': $sidebar_left = false; $sidebar_right = false; $class = ' col-md-12'; break;
	}
}
?>

<div class="container">
	<?php if( $sidebar_left ): ?>
		<aside id="widget-area" class="sidebar col-md-3" role="complementary">
			<?php dynamic_sidebar( 'sidebar-left' ); ?>
		</aside>
	<?php endif; ?>

	<main id="main" class="site-main<?php echo esc_attr( $class ); ?>" role="main">
		<?php
		// Start the loop.
		while ( have_posts() ) : the_post();

			// Include the page content template.
			the_content();

		// End the loop.
		endwhile;
		?>
	</main><!-- .site-main -->

	<?php if( $sidebar_right ): ?>
		<aside id="widget-area" class="sidebar col-md-3 col-md-offset-1" role="complementary">
			<?php dynamic_sidebar( 'sidebar-right' ); ?>
		</aside>
	<?php endif; ?>
</div>

<?php get_footer(); ?>
