<?php get_header();

/* Normal single posts */

$class = ' col-md-8 col-md-offset-2';
$sidebar_left = false;
$sidebar_right = false;

global $gfxbucket_options;

$meta = get_post_meta(get_the_id());

/* Global Options */

if( isset($gfxbucket_options['gfxbucket-post-sidebar']) ) {
	switch( $gfxbucket_options['gfxbucket-post-sidebar'] ) {
		case '2': $sidebar_left = true; $class = ' col-md-8 col-md-offset-1'; break;
		case '3': $sidebar_right = true; $class = ' col-md-8'; break;
	}
}

/* Post Options */

if( isset($meta['_gfxbucket_sidebar_status']) ) {
	switch( $meta['_gfxbucket_sidebar_status'][0] ) {
		case '1': $sidebar_left = true; $sidebar_right = false; $class = ' col-md-8 col-md-offset-1'; break;
		case '2': $sidebar_left = false; $sidebar_right = true; $class = ' col-md-8'; break;
		case '3': $sidebar_left = false; $sidebar_right = false; $class = ' col-md-8 col-md-offset-2'; break;
	}
}
?>

<div class="container">
	<div class="row">
		<?php if( $sidebar_left ): ?>
			<aside id="widget-area" class="sidebar col-md-3" role="complementary">
				<?php dynamic_sidebar( 'sidebar-left' ); ?>
			</aside>
		<?php endif; ?>
	
		<main id="main" class="site-main<?php echo esc_attr( $class ); ?>" role="main">
			
				<?php
					if ( have_posts() ) {
						while ( have_posts() ) { the_post();
							$cover_status = esc_attr( get_post_meta( get_the_id(), '_gfxbucket_cover_status', true ) );

							if( $cover_status == 1 ) {
								get_template_part( 'content-single-cover', get_post_format() );
							} else {
								get_template_part( 'content-single', get_post_format() );
							}

							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ) {
								comments_template();
							}
						}
					}
				?>
		</main>
		
		<?php if( $sidebar_right ): ?>
			<aside id="widget-area" class="sidebar col-md-3 col-md-offset-1" role="complementary">
				<?php dynamic_sidebar( 'sidebar-right' ); ?>
			</aside>
		<?php endif; ?>
	</div>
</div>


<?php get_footer(); ?>