<?php

global $portfolio_counter;
$portfolio_counter = 0;

function portfolio_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'load_more'   => 'yes',
		'per_page'    => 8,
		'categories'  => '',
		'type'        => 'masonry',
		'hover_style' => '',
		'filter'      => 'on',
		'wrapper'     => 'on',
		'exclude'     => '',
		'page'        => 1,
		'open_style'  => 'separate',
		'orderby'     => 'date',
		'order'       => 'DESC',
		'below_title' => 'categories',
	), $atts ));

	global $post, $portfolio_counter;

	$tax_query = '';
	$return = '';
	$portfolio_counter++;
	
	$current_page = (get_query_var('paged')) ? get_query_var('paged') : 1;

	// Portfolio type

	$portfolio_class = 'portfolio-' . $type;

	if( $type == 'masonry-style-2' || $type == 'masonry-style-3' ) {
		$portfolio_class = 'portfolio-masonry portfolio-style-2';
	}

	// Open style

	// Portfolio hover style

	if( $open_style == 'ajax' ) {
		$portfolio_class .= ' portfolio-ajax';
	}

	if( $open_style == 'image' ) {
		$portfolio_class .= ' portfolio-lightbox';
	}

	if( $type == 'masonry-spacing' ) {
		$portfolio_class .= ' portfolio-hover-style-2';
	} elseif( $hover_style ) {
		$portfolio_class .= ' portfolio-hover-' . $hover_style;
	}

	// Select only certain categories

	if( $categories ) {
		$tax_query = array(
		    array(
		      'taxonomy'         => 'portfolio_category',
		      'field'            => 'id',
		      'terms'            => explode(',', $categories),
		      'include_children' => false,
		      'operator'         => 'IN'
		    )
		);
	}

	// Arguments

	$args = array(
		'posts_per_page' => $per_page,
		'post_type'      => 'portfolio',
		'tax_query'      => $tax_query,
		'paged'          => $current_page,
		'orderby'        => $orderby,
		'order'          => $order,
	);

	if( $exclude != '' ) {
		$args = array(
			'posts_per_page' => $per_page,
			'post_type'      => 'portfolio',
			'tax_query'      => $tax_query,
			'post__not_in'   => explode(',', $exclude),
			'orderby'        => $orderby,
			'order'          => $order,
		);
	}

	$portfolio_posts = new WP_Query($args);

	$max_page = ceil($portfolio_posts->found_posts / (int) $per_page);
	$post_per_category = '';

	// Filter

	if( $filter == 'on' || $filter == 'true' || $filter == '1' ) {
		$return .= '<div class="filter"><ul>';

		$return .= '<li><button class="selected" data-filter="*">' . __( 'All', 'gfxbucket-shortcodes' ) . '</button><li>';

		$args = array(
			'taxonomy' => 'portfolio_category',
			'include'  => $categories
		);

		foreach( get_categories( $args ) as $category ) {
			$post_per_category .= ' data-' . $category->slug . '="' . $category->count . '"';
			$return .= '<li><button data-filter=".' . $category->slug . '">' . $category->cat_name . '</button><li>';
		}

		$return .= '</ul></div>';
	}

	if( $wrapper == 'on' ) {
		$return .= '<div class="portfolio ' . $portfolio_class . '" data-orderby="' . $orderby . '" data-order="' . $order . '" data-per-page="' . $per_page . '" data-type="' . $type . '" data-categories="' . $categories . '" data-max-page="' . $max_page . '" data-all="' . $portfolio_posts->found_posts . '"' . $post_per_category . '>';
	}

	$counter = 0;

	if( $page ) {
		$counter = $per_page * ($page - 1);
	}

	if ( $portfolio_posts->have_posts() ) {
		while ( $portfolio_posts->have_posts() ) { $portfolio_posts->the_post();
			$categories = get_the_terms( get_the_ID(), 'portfolio_category' );
			$below_title_content = '';
			$class = '';
			$image_size = 'portfolio-post';
			$meta = get_post_meta(get_the_id());
			$url = get_the_permalink();

			if( isset($meta['portfolio_custom_url']) && $meta['portfolio_custom_url'][0] != '' ) {
				$url = $meta['portfolio_custom_url'][0];
			}

			if( $open_style == 'image' ) {
				if( $meta['portfolio_video'] && strpos($meta['portfolio_video'], 'youtube') !== false ) {
					echo '<div class="fl-iframe-video"><iframe id="fl-' . $portfolio_counter . '-' . $counter . '" data-src="' . $meta['portfolio_video'][0] . '" frameborder="0" allowfullscreen></iframe></div>';
					$url = $meta['portfolio_video'][0] . '" data-featherlight="#fl-' . $portfolio_counter . '-' . $counter . '"';
				} elseif( $meta['portfolio_video'] && strpos($meta['portfolio_video'], 'vimeo') !== false ) {
					echo '<div class="fl-iframe-video"><iframe id="fl-' . $portfolio_counter . '-' . $counter . '" data-src="' . $meta['portfolio_video'][0] . '" frameborder="0" allowfullscreen></iframe></div>';
					$url = $meta['portfolio_video'][0] . '" data-featherlight="#fl-' . $portfolio_counter . '-' . $counter . '"';
				} else {
					$url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
					$url = $url[0];
				}
			}

			$counter++;

			if ( $type == 'masonry' && ($counter % 8 == 3 || $counter % 8 == 5) ) {
				$class .= ' portfolio-large';
				$image_size = 'portfolio-post-large';
			} elseif( $type == 'masonry-style-2' && ($counter % 9 == 3 || $counter % 9 == 5) ) {
				$class .= ' portfolio-large';
				$image_size = 'portfolio-post-large-2';
			} elseif( $type == 'masonry-style-3' && ($counter % 16 == 3 || $counter % 16 == 5 || $counter % 16 == 8) ) {
				$class .= ' portfolio-large';
				$image_size = 'portfolio-post-large-2';
			}  elseif( $type == 'masonry-spacing' && ($counter == 4 || $counter == 8 || $counter == 13 || $counter == 17 ) ) {
				$class .= ' portfolio-large';
				$image_size = 'portfolio-post-large-2';
			} elseif( $type == '4-columns' || $type == 'masonry-style-2' || $type == 'masonry-style-3' || $type == 'masonry-spacing' ) {
				$image_size = 'portfolio-4-columns';
			}

			$image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), $image_size );

			if( $categories ) {
				foreach ($categories as $category) {
					if( $below_title == 'categories' ) {
						if( $below_title_content != '' ) {
							$below_title_content .= ' / ';
						}
						$below_title_content .= $category->name;
					}
					$class .= ' ' . $category->slug;
				}
			}

			if( $below_title == 'short-desc' ) {
				$below_title_content = esc_html( $meta['portfolio_description'][0] );
			}

			$return .= '<article class="portfolio-item' . $class . '" data-id="' . get_the_ID() . '">';
				$return .= '<a href="' . $url . '">';
					$return .= '<img src="' . $image[0] . '" alt="' . get_the_title() . '">';
					$return .= '<div class="hover">';
						$return .= '<div class="hover-content">';
							$return .= '<h5>' . get_the_title() . '</h5>';
							if( $below_title != 'none' ) {
								$return .= '<span>' . $below_title_content . '</span>';
							}
						$return .= '</div>';
					$return .= '</div>';
				$return .= '</a>';
			$return .= '</article>';
			get_the_title();
		}
	}
	wp_reset_postdata();

	if( $wrapper == 'on' ) {
		$return .= '</div>';
	}

	/* Load More Button */

	$disabled = '';

	if( $max_page < 2 ) {
		$disabled = ' disabled="disabled"';
	}

	if( $load_more == 'yes' || $load_more == '1' ) {
		$return .= '<div class="row"><div class="col-md-12"><div class="portfolio-more"><button class="btn btn-lg"' . $disabled . '>' . __('Load More', 'gfxbucket-shortcodes') . '</button></div></div></div>';
	}

	return $return;
}
add_shortcode( 'portfolio', 'portfolio_func' );