<?php

function recent_posts_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'show_more_button' => 'no',
		'categories'       => '',
		'id'               => ''
	), $atts ));

	$args = array(
		'posts_per_page' => $content,
		'post_type'      => 'post',
		'category'       => $categories
	);

	global $post, $gfxbucket_options;
	$recent_posts = get_posts($args);
	$return = '';

	if( $id ) {
		$id = ' id="' . $id . '"';
	}

	$return .= '<div class="recent-posts"' . $id . '>';
	foreach( $recent_posts as $post ) { setup_postdata( $post );
		$image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'blog-strip' );
		$image = $image['0'];

		$return .= '<article style="background-image: url(' . $image . ');">';
		$return .= '<a href="' . get_the_permalink() . '">';
		$return .= '<div class="container"><div class="row"><div class="col-md-12">';
		$return .= '<time datetime="' . get_the_date('Y-m-d H:i') . '">' . get_the_date('M d, Y') . '</time>';
		$return .= '<h3>' . strip_tags( get_the_title() ) . '</h3>';
		$return .= '<span class="author">' . __('Posted by', 'gfxbucket-shortcodes') . ' <strong>' . get_the_author() . '</strong></span>';
		$return .= '</div></div></div>';
		$return .= '</a>';
		$return .= '</article>';
	}
	wp_reset_postdata();
	if( $show_more_button == 'yes' ) {
		$url = get_permalink( get_option( 'page_for_posts' ) );

		if(isset($gfxbucket_options['gfxbucket-recent-post-custom-url']) && $gfxbucket_options['gfxbucket-recent-post-custom-url'] != '') {
			$url = $gfxbucket_options['gfxbucket-recent-post-custom-url'];
		}

		$return .= '<a href="' . $url . '" class="blog-more">' . __('Read more', 'gfxbucket-shortcodes') . '</a>';
	}
	$return .= '</div>';

	return $return;
}
add_shortcode( 'recent_posts', 'recent_posts_func' );