<?php

/*
Widget Name: Counter widget
Description: A customizable counter widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Counter extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-counter',
			__('Gfxbucket Counter', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays a static or animated counter element.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-plus-square-o'
			),
			array(),
			array(
				'counter_item' => array(
					'type' => 'repeater',
					'label' => __( 'Counter elements' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'Counter Item', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='counter_item']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(
						'icon' => array(
							'type' => 'icon',
							'label' => __('Select an icon', 'gfxbucket-shortcodes'),
						),
						'image' => array(
							'type' => 'media',
							'label' => __( 'Counter image', 'gfxbucket-shortcodes' ),
							'choose' => __( 'Choose image', 'gfxbucket-shortcodes' ),
							'update' => __( 'Set image', 'gfxbucket-shortcodes' ),
							'description'   => __( 'Use your own counter image.', 'gfxbucket-shortcodes' ),
							'library' => 'image'
						),
						'title' => array(
							'type' => 'text',
							'label' => __( 'Title', 'gfxbucket-shortcodes' )
						),
						'number' => array(
							'type' => 'number',
							'label' => __( 'Number', 'gfxbucket-shortcodes' )
						)
					)
				),
				'animate' => array(
					'type' => 'checkbox',
					'label' => __( 'Counter animating when in view?', 'gfxbucket-shortcodes' ),
					'default' => true
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-counter', __FILE__, 'Gfxbucket_Counter');