<?php

/*
Widget Name: Google Maps widget
Description: A basic Google Maps widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Google_Maps extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-google-maps',
			__('Gfxbucket Google Maps', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays a map of a selected location.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-map-marker'
			),
			array(),
			array(
				'location' => array(
					'type' => 'text',
					'label' => __( 'Location', 'gfxbucket-shortcodes' ),
					'default' => '121 King Street, Melbourne',
					'description' => __( 'The name of a place, town, city, country or an exact address.', 'gfxbucket-shortcodes' ),
				),
				'zoom' => array(
					'type' => 'slider',
					'label' => __( 'Zoom', 'gfxbucket-shortcodes' ),
					'description' => __( 'A value from 0 (the world) to 21 (street level).', 'gfxbucket-shortcodes' ),
					'default' => 14,
					'min' => 0,
					'max' => 21,
				),
				'marker' => array(
			        'type' => 'media',
			        'label' => __( 'Marker icon', 'gfxbucket-shortcodes' ),
			        'description' => __( 'Replaces the default map marker with your own image.', 'gfxbucket-shortcodes' ),
			        'library' => 'image',
    			),
				'scrollwheel' => array(
			        'type' => 'checkbox',
			        'label' => __( 'Scroll to zoom', 'gfxbucket-shortcodes' ),
			        'description' => __( 'Allow scrolling over the map to zoom in or out.', 'gfxbucket-shortcodes' ),
			        'default' => false,
			    ),
				'draggable' => array(
			        'type' => 'checkbox',
			        'label' => __( 'Draggable', 'gfxbucket-shortcodes' ),
			        'description' => __( 'Allow dragging the map to move it around.', 'gfxbucket-shortcodes' ),
			        'default' => true,
			    )
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-google-maps', __FILE__, 'Gfxbucket_Google_Maps');