<?php

/*
Widget Name: Instagram widget
Description: A customizable instagram widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Instagram extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-instagram',
			__('Gfxbucket Instagram', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays account details of an Instagram account with images in the background.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-instagram'
			),
			array(),
			array(
				'user_id' => array(
					'type' => 'text',
					'label' => __( 'Instagram User ID', 'gfxbucket-shortcodes' ),
					'default' => '269801886'
				),
				'animate' => array(
					'type' => 'checkbox',
					'label' => __( 'Animate when in view?', 'gfxbucket-shortcodes' ),
					'default' => false
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-instagram', __FILE__, 'Gfxbucket_Instagram');