<?php

/*
Widget Name: Progress bar widget
Description: A customizable progress bar widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Progress_Bar extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-progress-bar',
			__('Gfxbucket Progress Bar', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays a progress bar with a certain value.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-tasks'
			),
			array(),
			array(
				'title' => array(
					'type' => 'text',
					'label' => __( 'Title', 'gfxbucket-shortcodes' ),
					'default' => ''
				),
				'subtitle' => array(
					'type' => 'text',
					'label' => __( 'Subtitle', 'gfxbucket-shortcodes' ),
					'default' => ''
				),
				'value' => array(
					'type' => 'number',
					'label' => __( 'Value', 'gfxbucket-shortcodes' ),
					'default' => '30'
				),
				'max' => array(
					'type' => 'number',
					'label' => __( 'Max Value', 'gfxbucket-shortcodes' ),
					'default' => '100'
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-progress-bar', __FILE__, 'Gfxbucket_Progress_Bar');