<?php
	$section_items = '';
	foreach($instance['section_items'] as $item) {
		$image = $item[$item['form_type']]['image_fallback'];

		if( $item[$item['form_type']]['image'] ) {
			$image = wp_get_attachment_image_src($item[$item['form_type']]['image'], 'full');
			$image = $image[0];
		}

		switch( $item['form_type'] ) {
			/* Instagram */
			case 'instagram':
				$section_items .= '[section_fs_instagram';
				$section_items .= ' id="' . $item['instagram']['instagram_id'] . '"';
			break;

			/* Twitter */
			case 'twitter':
				$section_items .= '[section_fs_twitter';
				$section_items .= ' username="' . $item['twitter']['twitter_username'] . '"';
			break;

			/* Contact Form 7 */
			case 'contact':
				$section_items .= '[section_fs_contact';
				$section_items .= ' title="' . $item['contact']['title'] . '"';
				$section_items .= ' animate="' . $item['contact']['animate'] . '"';
				$section_items .= ' image="' . $image . '"';
				$section_items .= ' id="' . $item['contact']['contact_id'] . '"';
			break;

			/* Advanced Text */
			case 'advanced':
				$section_items .= '[section_fs_advanced';
				$section_items .= ' animate="' . $item['advanced']['animate'] . '"';
				$section_items .= ' image="' . $image . '"';
				$section_items .= ' box_align_x="' . $item['advanced']['box_align_x'] . '"';
				$section_items .= ' box_align_y="' . $item['advanced']['box_align_y'] . '"';
				$section_items .= ' tooltip="' . $item['tooltip'] . '"';
				$section_items .= ' align="' . $item['advanced']['align'] . '"';
				$section_items .= ' slug="' . $item['slug'] . '"';
				$section_items .= ' ]';
				$section_items .= $item['advanced']['content'];
				$section_items .= '[/section_fs_advanced]';
			break;
		
			/* Simple */
			default:
				$new_window = '';

				if( !empty($instance['simple']['new_window']) ) {
					$new_window = 'true';
				}

				$section_items .= '[section_fs_simple';
				$section_items .= ' animate="' . $item['simple']['animate'] . '"';
				$section_items .= ' image="' . $image . '"';
				$section_items .= ' new_window="' . $new_window . '"';
				$section_items .= ' title="' . do_shortcode($item['simple']['title']) . '"';
				$section_items .= ' align="' . $item['simple']['align'] . '"';
				$section_items .= ' text="' . $item['simple']['text'] . '"';
				$section_items .= ' link="' . $item['simple']['link'] . '"';
				$section_items .= ' link_text="' . $item['simple']['link_text'] . '"';
			break;
		}

		/* Global options */
		if( $item['form_type'] != 'advanced' ) {
			$section_items .= ' tooltip="' . $item['tooltip'] . '"';
			$section_items .= ' slug="' . $item['slug'] . '"';
			$section_items .= ' /]';
		}
	}
	
	echo do_shortcode('[section_fs navigation="' . $instance['navigation'] . '" scrollbar="' . $instance['scrollbar'] . '"]' . $section_items . '[/section_fs]');
?>