<?php

/*
Widget Name: Tab widget
Description: A customizable tab widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Tab extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-tab',
			__('Gfxbucket Tab', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays a single content area with multiple panels, each associated with a header in a list.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-columns'
			),
			array(),
			array(
				'tab' => array(
					'type' => 'repeater',
					'label' => __( 'Tab Item' , 'gfxbucket-shortcodes' ),
					'item_name'  => __( 'Tab Item', 'gfxbucket-shortcodes' ),
					'item_label' => array(
						'selector'     => "[id*='tab']",
						'update_event' => 'change',
						'value_method' => 'val'
					),
					'fields' => array(
						'title' => array(
							'type' => 'text',
							'label' => __( 'Title', 'gfxbucket-shortcodes' )
						),
						'text' => array(
							'type' => 'tinymce',
							'label' => __( 'Text', 'gfxbucket-shortcodes' )
						),
					)
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'template';
	}

	function get_style_name($instance) {
		return 'style';
	}
}

siteorigin_widget_register('gfxbucket-tab', __FILE__, 'Gfxbucket_Tab');