<?php

/*
Widget Name: Button widget
Description: A customizable title widget.
Author: Gfxbucket
Author URI: http://themeforest.net/user/gfxbucket
*/

class Gfxbucket_Title extends SiteOrigin_Widget {
	function __construct() {
		parent::__construct(
			'gfxbucket-title',
			__('Gfxbucket Title', 'gfxbucket-shortcodes'),
			array(
				'description'  => __('Displays a heading element. Allows multiple styles and sizes.', 'gfxbucket-shortcodes'),
				'panels_groups' => array('gfxbucket-widgets'),
				'panels_icon' => 'fa fa-header'
			),
			array(),
			array(
				'text' => array(
					'type' => 'text',
					'label' => __( 'Text', 'gfxbucket-shortcodes' ),
					'default' => 'Lorem ipsum dolor'
				),
				'style' => array(
					'type' => 'select',
					'label' => __( 'Style', 'gfxbucket-shortcodes' ),
					'default' => 'style-1',
					'options' => array(
						'style-1' => __( 'Style 1', 'gfxbucket-shortcodes' ),
						'style-2' => __( 'Style 2', 'gfxbucket-shortcodes' ),
						'style-3' => __( 'Style 3', 'gfxbucket-shortcodes' ),
					)
				),
				'size' => array(
					'type' => 'select',
					'label' => __( 'Size', 'gfxbucket-shortcodes' ),
					'default' => 'h2',
					'options' => array(
						'h1' => __( 'H1', 'gfxbucket-shortcodes' ),
						'h2' => __( 'H2', 'gfxbucket-shortcodes' ),
						'h3' => __( 'H3', 'gfxbucket-shortcodes' ),
						'h4' => __( 'H4', 'gfxbucket-shortcodes' ),
						'h5' => __( 'H5', 'gfxbucket-shortcodes' ),
						'h6' => __( 'H6', 'gfxbucket-shortcodes' ),
					)
				),
				'id' => array(
					'type' => 'text',
					'label' => __( 'ID (used for anchor navigation)', 'gfxbucket-shortcodes' ),
					'default' => ''
				),
			),
			plugin_dir_path(__FILE__)
		);
	}

	function get_template_name($instance) {
		return 'title-template';
	}

	function get_style_name($instance) {
		return 'title-style';
	}
}

siteorigin_widget_register('gfxbucket-title', __FILE__, 'Gfxbucket_Title');