<?php
function theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
if ( !is_admin() ) {
	function custom_scripts() {
		wp_register_script( 'assets', get_stylesheet_directory_uri() . '/js/stopExecutionOnTimeout.js', array('jquery'), 1, true );
		wp_register_script( 'custom-script', get_stylesheet_directory_uri() . '/js/script.js', array('jquery'), 1, true );
		wp_register_script( 'scroll-to', get_stylesheet_directory_uri() . '/js/jquery.scrollTo-1.4.2-min.js', array('jquery'), 1, true );
		wp_enqueue_script( 'assets' );
		wp_enqueue_script( 'custom-script' );
		wp_enqueue_script( 'scroll-to' );
	}
	add_action( 'after_setup_theme', 'custom_scripts' );
}





function filtros_func() {
    
  $exporter .='<div class="fixed-top"><div class="filter">';



  $exporter .= '<div class="styled-select styled-select3"><select id="filtropais">';
  $exporter .= ' <option value="0">PAÍS</option>';

  $argsPais = array('parent' => 3,
                  'taxonomy' => 'portfolio_category',
      );



    $categories = get_categories( $argsPais );


    foreach($categories as $category) { 
        $exporter .= ' <option class="obrasOption" value="';
        $exporter.= $category->name; 
        $exporter .= '">';
        $exporter .= $category->name; 
        $exporter .= '</option>';

     }

    


     $exporter .= "</select></div>";


  $exporter .= '<div class="styled-select styled-select4"><select id="filtroactividad">';
  $exporter .= ' <option value="0">ACTIVIDAD</option>';

  

    $argsActividad = array('parent' => 116,
                  'taxonomy' => 'portfolio_category',
      );

  

    $categories = get_categories( $argsActividad );


    foreach($categories as $category) { 
        $exporter .= ' <option class="obrasOption" value="';
        $exporter.= $category->name; 
        $exporter .= '">';
        $exporter .= $category->name; 
        $exporter .= '</option>';

     }

    


     $exporter .= "</select></div>";
     $exporter .= '<a id="FiltroButton" href="#n">Filtrar</a>';
     $exporter .= '<a id="FiltroButton2" href="#n">Dejar de filtrar</a>';
     $exporter .= '<span class="filter-link"><a href="#n" class="equipoBtn">Casos destacados</a><a href="#listadoCom" class="equipoBtn">Listado completo de casos</a></span></div>';
     $exporter .= '</div></div>';


   return $exporter;
 }




function grilla_func() {

    $the_query = new WP_Query( array(

        'post_type'      => 'portfolio',
        'nopaging'        => true,
        'orderby'          => 'modified',
        'order'   => 'DESC',
        'portfolio_category'        => 'Casos destacados',
      
    ) );

    if ( $the_query->have_posts() ) {
      
      $counter = 0;

      $return = '<div class="portfolio portfolio-masonry-spacing portfolio-hover-style-2">';

      while (  $the_query->have_posts() ) : $the_query->the_post(); 
        
        $image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), $image_size );


         $actividad = get_field( "actividad" );
         $ano = get_field( "ano" );
         $pais = get_field( "pais" );



        $url = get_the_permalink();



        if($counter<=22){


          if($counter==2){
              $return .= '<article class="largeItem pagina1 '.$ano.' '.$pais.' '.$actividad.' destacados portfolio-item '. $class . '" data-id="' . get_the_ID() . '">';

          }elseif($counter==4 || $counter==13 || $counter==15 ){
                $return .= '<article class="largeItemOnGrid  pagina1 '.$ano.' '.$pais.' '.$actividad.' destacados portfolio-item '. $class . '" data-id="' . get_the_ID() . '">';
          }else{
                $return .= '<article class="pagina1 '.$ano.' '.$pais.' '.$actividad.' destacados portfolio-item '. $class . '" data-id="' . get_the_ID() . '">';
          }

          

        } elseif($counter >22 && $counter <= 44){

          $return .= '<article class="pagina2 '.$ano.' '.$pais.' '.$actividad.' destacados portfolio-item '. $class . '" data-id="' . get_the_ID() . '">';

        } elseif($counter >44){

          $return .= '<article class="pagina3 '.$ano.' '.$pais.' '.$actividad.' destacados portfolio-item '. $class . '" data-id="' . get_the_ID() . '">';

        }

        


        $return .= '<a href="' . $url . '">';
          $return .= '<img src="' . $image[0] . '" alt="' . get_the_title() . '">';
          $return .= '<div class="hover">';
            $return .= '<div class="hover-content">';
              $return .= '<h5>' . get_the_title() . '</h5>';
              if( $below_title != 'none' ) {
                $return .= '<span>' .$actividad.' / '.$pais. '</span>';
              }
            $return .= '</div>';
          $return .= '</div>';
        $return .= '</a>';
          $return .= '</article>';


          $counter = $counter +1;

        endwhile;
 
          wp_reset_postdata();

    }

      $return.='<div id="paginadorWp">';

        $divisor = $counter / 22;
        $return.='<p>';
        for($i=0 ; $i<$divisor ; $i++){

            $return.='<a href="#n" class="botonGrilla" data-page="pagina';
            $return.= $i+1;
            $return.='"></a>';

        };


        $return.='</p>';

        $return.='</div>';

      $return.='</div>';
    
       return $return;
}


function menu_encuesta() {
    
     $return='<div class="anossWp">';

     $url = get_site_url();
     
     $return.=' <a id="2005" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2005/#pg-2397-1" class="">2005</a>
                <a id="2006" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2006/#pgc-2372-1-0" class="">2006</a>
                <a id="2007" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2007/#pgc-2367-1-0" class="">2007</a>
                <a id="2008" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2008/#pgc-2359-1-0" class="">2008</a>
                <a id="2009" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2009/#pgc-2335-1-0" class="">2009</a>
                <a id="2010" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2010/#pg-2332-1" class="">2010</a>
                <a id="2011" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2011/#pgc-2329-1-0" class="">2011</a>
                <a id="2012" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2012/#pg-2321-1" class="">2012</a>
                <a id="2013" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2013/#pgc-2301-1-0" class="">2013</a>
                <a id="2014" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2014/#pgc-2315-1-0" class="">2014</a>
                <a id="2015" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2015/#pg-2263-1" class="">2015</a>
                <a id="2016" href="'.$url.'/encuesta-de-satisfaccion-al-cliente-2016/#pg-2258-1" class="">2016</a>';

     $return.='</div>';


   return $return;
 }



function custom_shortcode_func() {
 


$anoAr = array(); 
$actividadAr = array(); 
$paisAr = array(); 

$exporter;



$exporter = '
<div class="filtrosWp"></div>

<table id="rowsCasos" style="width:100%" >
   <tr class="bolder">
    <td>Cliente</td> 
    <td>Actividad</td>
    <td>País</td>
    <td>Año</td>
  </tr>';


$the_query = new WP_Query( array(

    'post_type'              => array( 'portfolio' ),
    'nopaging'               => true,
    'paged'                  => '10',
    'posts_per_page'         => '10',
    'orderby'                => 'title',
    'order'   => 'ASC',
  

	) );

/*  'meta_key'               => 'actividad',
    'meta_value'             => 'Agropecuaria'*/

      $counter = 0;


 if ( $the_query->have_posts() ) {

    while ( $the_query->have_posts() ) : $the_query->the_post(); 

           $selected = get_field('link');
           $actividad = get_field( "actividad" );
           $ano = get_field( "ano" );
           $pais = get_field( "pais" );
           $idPost =  $post->ID;


              if($counter<70){


                 $exporter .=  '<tr class="'.$ano.' '.$pais.' '.$actividad.' pagina1">';

              } elseif($counter>70 &&$counter<140){


               $exporter .=  '<tr class="'.$ano.' '.$pais.' '.$actividad.' pagina2 ">';


              }elseif($counter>140 &&$counter<210){


               $exporter .=  '<tr class="'.$ano.' '.$pais.' '.$actividad.' pagina3 ">';


              }elseif($counter>210 &&$counter<280){


               $exporter .=  '<tr class="'.$ano.' '.$pais.' '.$actividad.' pagina4 ">';


              }elseif($counter>280 &&$counter<350){


               $exporter .=  '<tr class="'.$ano.' '.$pais.' '.$actividad.' pagina5 ">';


              }elseif($counter>350 &&$counter<420){


               $exporter .=  '<tr class="'.$ano.' '.$pais.' '.$actividad.' pagina6 ">';


              }elseif($counter>420 &&$counter<490){


               $exporter .=  '<tr class="'.$ano.' '.$pais.' '.$actividad.' pagina7 ">';


              }elseif($counter>490 &&$counter<560){


               $exporter .=  '<tr class="'.$ano.' '.$pais.' '.$actividad.' pagina8 ">';


              }elseif($counter>560 &&$counter<630){


               $exporter .=  '<tr class="'.$ano.' '.$pais.' '.$actividad.' pagina9 ">';


              }elseif($counter>630 &&$counter<700){


               $exporter .=  '<tr class="'.$ano.' '.$pais.' '.$actividad.' pagina10 ">';


              }



               $exporter .=  '<td>';

               if ( has_term( 'Casos destacados', 'portfolio_category', $idPost ) ){
                         

                             $exporter .=  '<a target="_blank" href="'.get_the_permalink().'"><i class="fa fa-instagram"></i> ';


               } else{
                             $exporter .=  '<a target="_blank" href="'.get_the_permalink().'">';


               };


               $title = get_the_title();
               $exporter .=  $title;
             
               $exporter .=  '</a>';
               $exporter .=  '</td>';

             
              
            
              $exporter .=  '<td>';
               
                $exporter .=  $actividad;

                if  ($actividad!= ""){

                if (in_array($actividad, $actividadAr)) {
                
                    //echo "Existe esta variable".$ano;
                
                }else{

                 //echo "no existe";
                  array_push($actividadAr, $actividad);
                }

                }else{
                  //echo "hay un espacio";
                }

              $exporter .=  '</td>';
              $exporter .=  '<td>';
                
                $exporter .=  $pais;

                if  ($pais!= ""){

                if (in_array($pais, $paisAr)) {
                
                    //echo "Existe esta variable".$ano;
                
                }else{

                 //echo "no existe";
                  array_push($paisAr, $pais);
                }

                }else{
                  //echo "hay un espacio";
                }

              $exporter .=  '</td>';
              $exporter .=  '<td>';

                $exporter .=  $ano;
               
                if  ($ano!= ""){
                
                  if (in_array($ano, $anoAr)) {
                      //echo "Existe esta variable".$ano;
                  
                  }else{

                   //echo "no existe";
                    array_push($anoAr, $ano);
                  }

                }else{
                  //echo "hay un espacio";
                }

              $exporter .=  '</td>';
        
          $exporter .=  '<tr>';

      $counter = $counter+1;

   
    endwhile;
 
    wp_reset_postdata(); 

     $exporter .=  '</table>';


     $exporter.='<div id="paginadorWp2">';

        $divisor = $counter / 70;
        $exporter.='<p>';
        for($i=0 ; $i<$divisor ; $i++){

            $exporter.='<a href="#listadoCom" class="botonTabla" data-page="pagina';
            $exporter.= $i+1;
            $exporter.='"></a>';

        };


        $exporter.='</p>';

        $exporter.='</div>';

      $exporter.='</div>';
    

//ordeno arrays

  sort($anoAr);
  sort($paisAr);
  sort($actividadAr);
     
 $largoanos = count($anoAr);
 $largopais = count($paisAr);
 $largoactividad = count($actividadAr);

   $exporter .='<div class="fixed-top"><div class="filter">';

  $exporter .= '<div  class="filter-select"><div style="display:none" class="styled-select"><select id="filtroano">';
  $exporter .= ' <option value="0">AÑO</option>';

 for($i=0;$i<$largoanos;$i++){

     $exporter .= ' <option class="obrasOption" value="';
     $anoArray = $anoAr[$i];
     $exporter .= $anoArray;
     $exporter .= '">';
     $exporter .= $anoArray;
     $exporter .= '</option>';

 }

  $exporter .= "</select></div>";
 


  $exporter .= '<div class="styled-select styled-select3"><select id="filtropais">';
  $exporter .= ' <option value="0">PAÍS</option>';

 for($i=0;$i<$largopais;$i++){

     $exporter .= ' <option class="obrasOption" value="';
     $paisArray = $paisAr[$i];
     $exporter .= $paisArray;
     $exporter .= '">';
     $exporter .= $paisArray;
     $exporter .= '</option>';

 }
  $exporter .= "</select></div>";

  $exporter .= '<div class="styled-select styled-select4"><select id="filtroactividad">';
  $exporter .= ' <option value="0">ACTIVIDAD</option>';
 
  for($i=0;$i<$largoactividad;$i++){
     $exporter .= ' <option class="obrasOption" value="';
     $actividadArray = $actividadAr[$i];
     $exporter .= $actividadArray;
      $exporter .= '">';
      $exporter .= $actividadArray;
      $exporter .= '</option>';
 }
 
 $exporter .= "</select></div>";
 $exporter .= '<a id="FiltroButton" href="#n">Filtrar</a>';
 $exporter .= '<a id="FiltroButton2" href="#n">Dejar de filtrar</a>';
 $exporter .= '<span class="filter-link"><a href="#n" class="equipoBtn">Casos destacados</a><a href="#listadoCom" class="equipoBtn">Listado completo de casos</a></span></div>';
  $exporter .= '</div></div>';


$exporter.='  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.isotope/2.2.2/isotope.pkgd.js"></script>';
  

}





   return $exporter;
}


add_shortcode( 'custom_shortcode', 'custom_shortcode_func' );

add_shortcode( 'grilla', 'grilla_func' );

add_shortcode( 'menu', 'menu_encuesta' );

add_shortcode( 'filtros', 'filtros_func' );

//add_shortcode('grilla_corta', 'grilla_func_short');