<?php
	$categories = get_the_category();
	$category_list = '';
	$idPost = get_the_ID();
	$link_publicacion = get_field( "link_publicacion", $idPost);
	$link_fasciculos = get_field( "link_fasciculos", $idPost);
	$tipoPost =  get_post_type ($idPost);


	if($categories) {
		foreach ($categories as $category) {
			if( $category_list != '' ) {
				$category_list .= ', ';
			}
			$category_list .= $category->name;
		}
	}

	global $more, $image_size;
	$more = 0;

	if( !$image_size ) {
		$image_size = '';
	}

	$post_class = 'blog-posts';

	/* Add sticky class to featured posts (added for shortcode support) */

	if( is_sticky() ) {
		$post_class .= ' sticky';
	}

	/* Add no avatar class */

	if( !get_option('show_avatars') ) {
		$post_class .= ' no-avatar';
	}
?>



<article data-typse="<?php echo 	$tipoPost ?>" id="post-<?php the_ID(); ?>" <?php post_class($post_class); ?>>
	<header>
		<?php if( is_sticky() ): ?>
			<div class="sticky-header"><?php _e( 'Featured Post', 'dropout' ); ?></div>
		<?php endif; ?>
		<?php if ( has_post_thumbnail() && get_the_post_thumbnail() ): ?>
			<?php

			if($category_list == "Publicaciones"){

				echo '<a target="_blank" class="blog-post-image" href="';

				echo  $link_publicacion;


			}elseif ($category_list == "Fasciculos") {

				echo '<a target="_blank" class="blog-post-image" href="';

				echo  $link_fasciculos;


			} else{

				echo '<a  class="blog-post-image" href="';

				echo get_the_permalink();
			};

			echo '">';

			 ?>



				<?php the_post_thumbnail($image_size); ?>
			</a>
			<div class="blog-post-author">
				<?php if( get_option('show_avatars') ): ?>
					<div class="blog-post-author-image">
						<?php echo get_avatar( get_the_author_meta( 'ID' ) ); ?>
					</div>
				<?php endif; ?>
				<div class="blog-post-author-details">
					<?php _e( 'By', 'dropout' ); ?> <span class="author-name"><?php the_author(); ?></span>
					<?php _e( 'on', 'dropout' ); ?> <time datetime="2014-09-10 17:00"><?php echo get_the_date('M jS, Y'); ?></time>
					<?php _e( 'in', 'dropout' ); ?> <span class="categories"><?php echo esc_html( $category_list ); ?></span>
				</div>
			</div>
		<?php endif; ?>

	</header>
	<div class="blog-post-content">

		<a href="<?php 	if($category_list == "Publicaciones"){

				echo  $link_publicacion;


			}elseif ($category_list == "Fasciculos") {

				echo  $link_fasciculos;
			} else{

				echo get_the_permalink();
			};


			?> " class="blogTitleWp" target="_blank" ><h2 class="blog-post-title"><?php the_title(); ?></h2></a>

		<div class="excerptWp">
			<?php the_excerpt(); ?>

		</div>

		<?php /*if(get_option("rss_use_excerpt") == "0"): ?>
			<?php the_content(); ?>
		<?php else: ?>
			<?php the_excerpt(); ?>
		<?php endif; */?>
	</div>
	<footer class="masnews">
		<a href="<?php

			if($category_list == "Publicaciones"){

				echo  $link_publicacion;


			}elseif ($category_list == "Fasciculos") {

				echo  $link_fasciculos;
			} else{

				echo get_the_permalink();
			};

				?> "  target="_blank" class="more"><?php _e( 'Read more', 'dropout' ); ?></a>


		<a href="<?php echo get_the_permalink(); ?>#comments" class="blog-post-comments-link">
			<i class="fa fa-comment-o"></i>
			<?php comments_number( __('0 comments', 'dropout'), __('1 comment', 'dropout'), __('% comments', 'dropout') ); ?>
			<i class="fa fa-share"></i>
		</a>
	</footer>
</article>
