<?php

class GfxbucketPageMeta {
	public $id;
	public $name;
	public $label;
	public $desc;
	public $type;
	public $options;
	public $value;

    public function __construct( $name, $label, $desc, $post_id, $type, $options ) {
    	$this->id = str_replace('_', '-', $name);
        $this->name = '_gfxbucket_' . $name;
        $this->label = $label;
        $this->desc = $desc;
        $this->type = $type;
        $this->options = $options;
        $this->value = esc_attr( get_post_meta( $post_id, $this->name, true ) );
    }

    public function gfxbucketGetPageMeta() {
		?>
		<div class="gfxbucket-meta-option">
			<label for="<?php echo esc_attr( $this->id ); ?>"><?php echo esc_html( $this->label ); ?></label>
			<?php if( $this->type == 'select' ): ?>
				<select name="<?php echo esc_attr( $this->name ); ?>" id="<?php echo esc_attr( $this->id ); ?>">
					<?php if( $this->name == '_gfxbucket_menu' ): $menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) ); ?>
						<option value="0"></option>
						<?php foreach( $menus as $menu ): ?>
							<option value="<?php echo esc_attr( $menu->term_id ); ?>"<?php if( $this->value == $menu->term_id ) { echo ' selected'; } ?>><?php echo esc_html( $menu->name ); ?></option>
						<?php endforeach; ?>
					<?php else: ?>
						<?php foreach ($this->options as $key => $value): ?>
							<option value="<?php echo esc_attr( $key ); ?>"<?php if( $this->value == $key ) { echo ' selected'; } ?>><?php echo esc_html( $value ); ?></option>
						<?php endforeach;
					endif; ?>
				</select>
			<?php else: ?>
				<input type="text" id="<?php echo esc_attr( $this->id ); ?>" name="<?php echo esc_attr( $this->name ); ?>" value="<?php echo esc_attr( $this->value ); ?>">
			<?php endif; ?>
			<p><?php echo esc_html( $this->desc ); ?></p>
		</div>
    <?php }
}