/* global confirm, redux, redux_change */

jQuery(document).ready(function($) {

	var importer = $('#gfxbucket-import button');
	var already = false;

	importer.on('click', function(e) {
		if( $('[data-warning]').length || already ) {
			var warning = window.confirm($('[data-warning]').attr('data-warning'));

			if( !warning ) {
				e.preventDefault(); 
				return false;
			}
		}

		$('#gfxbucket-import').addClass('importing');
		$('#gfxbucket-import').removeClass('importing-done');
		$('#gfxbucket-import button').prop('disabled', true);
		$('.import-done').html('');

		$('html, body').animate({ scrollTop:  $('#import-status').offset().top - 50 }, 'slow');

		$.ajax({
			url: dummy.ajaxurl,
			type: 'post',
			data: {
				demo_id: $(this).attr('id'),
				action: 'demo_content',
			},
		  	success: function(response) {
		  		already = true;
		  		$('#gfxbucket-import button').prop('disabled', false);
		  		$('#gfxbucket-import').removeClass('importing');
		  		$('#gfxbucket-import').addClass('importing-done');

		  		$('.import-done').html(response);
			}
		});

		e.preventDefault(); 
		return false;
	});
});
