<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Gfxbucket_Framework_config' ) ) {

        class Gfxbucket_Framework_config {

            public $args = array();
            public $sections = array();
            public $theme;
            public $ReduxFramework;

            public function __construct() {

                if ( ! class_exists( 'ReduxFramework' ) ) {
                    return;
                }

                // This is needed. Bah WordPress bugs.  ;)
                if ( true == Redux_Helpers::isTheme( __FILE__ ) ) {
                    $this->initSettings();
                } else {
                    add_action( 'plugins_loaded', array( $this, 'initSettings' ), 10 );
                }

            }

            public function initSettings() {

                // Just for demo purposes. Not needed per say.
                $this->theme = wp_get_theme();

                // Set the default arguments
                $this->setArguments();

                // Set a few help tabs so you can see how it's done
                $this->setHelpTabs();

                // Create the sections and fields
                $this->setSections();

                if ( ! isset( $this->args['opt_name'] ) ) { // No errors please
                    return;
                }

                // If Redux is running as a plugin, this will remove the demo notice and links
                //add_action( 'redux/loaded', array( $this, 'remove_demo' ) );

                // Function to test the compiler hook and demo CSS output.
                // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
                //add_filter('redux/options/'.$this->args['opt_name'].'/compiler', array( $this, 'compiler_action' ), 10, 3);

                // Change the arguments after they've been declared, but before the panel is created
                //add_filter('redux/options/'.$this->args['opt_name'].'/args', array( $this, 'change_arguments' ) );

                // Change the default value of a field after it's been set, but before it's been useds
                //add_filter('redux/options/'.$this->args['opt_name'].'/defaults', array( $this,'change_defaults' ) );

                // Dynamically add a section. Can be also used to modify sections/fields
                //add_filter('redux/options/' . $this->args['opt_name'] . '/sections', array($this, 'dynamic_section'));

                $this->ReduxFramework = new ReduxFramework( $this->sections, $this->args );
            }

            /**
             * This is a test function that will let you see when the compiler hook occurs.
             * It only runs if a field    set with compiler=>true is changed.
             * */
            function compiler_action( $options, $css, $changed_values ) {
                echo '<h1>The compiler hook has run!</h1>';
                echo "<pre>";
                print_r( $changed_values ); // Values that have changed since the last save
                echo "</pre>";
                //print_r($options); //Option values
                //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )

                /*
              // Demo of how to use the dynamic CSS and write your own static CSS file
              $filename = dirname(__FILE__) . '/style' . '.css';
              global $wp_filesystem;
              if( empty( $wp_filesystem ) ) {
                require_once( ABSPATH .'/wp-admin/includes/file.php' );
              WP_Filesystem();
              }

              if( $wp_filesystem ) {
                $wp_filesystem->put_contents(
                    $filename,
                    $css,
                    FS_CHMOD_FILE // predefined mode settings for WP files
                );
              }
             */
            }

            /**
             * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
             * Simply include this function in the child themes functions.php file.
             * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
             * so you must use get_template_directory_uri() if you want to use any of the built in icons
             * */
            function dynamic_section( $sections ) {
                //$sections = array();
                $sections[] = array(
                    'title'  => __( 'Section via hook', 'dropout' ),
                    'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'dropout' ),
                    'icon'   => 'el-icon-paper-clip',
                    // Leave this as a blank section, no options just some intro text set above.
                    'fields' => array()
                );

                return $sections;
            }

            /**
             * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
             * */
            function change_arguments( $args ) {
                //$args['dev_mode'] = true;

                return $args;
            }

            /**
             * Filter hook for filtering the default value of any given field. Very useful in development mode.
             * */
            function change_defaults( $defaults ) {
                $defaults['str_replace'] = 'Testing filter hook!';

                return $defaults;
            }

            // Remove the demo link and the notice of integrated demo from the redux-framework plugin
            function remove_demo() {

                // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
                if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                    remove_filter( 'plugin_row_meta', array(
                        ReduxFrameworkPlugin::instance(),
                        'plugin_metalinks'
                    ), null, 2 );

                    // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                    remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
                }
            }

            public function setSections() {

                /**
                 * Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
                 * */
                // Background Patterns Reader
                $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
                $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
                $sample_patterns      = array();

                if ( is_dir( $sample_patterns_path ) ) :

                    if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) :
                        $sample_patterns = array();

                        while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                            if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                                $name              = explode( '.', $sample_patterns_file );
                                $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                                $sample_patterns[] = array(
                                    'alt' => $name,
                                    'img' => $sample_patterns_url . $sample_patterns_file
                                );
                            }
                        }
                    endif;
                endif;

                ob_start();

                $ct          = wp_get_theme();
                $this->theme = $ct;
                $item_name   = $this->theme->get( 'Name' );
                $tags        = $this->theme->Tags;
                $screenshot  = $this->theme->get_screenshot();
                $class       = $screenshot ? 'has-screenshot' : '';

                $customize_title = sprintf( __( 'Customize &#8220;%s&#8221;', 'dropout' ), $this->theme->display( 'Name' ) );

                ?>
                <div id="current-theme" class="<?php echo esc_attr( $class ); ?>">
                    <?php if ( $screenshot ) : ?>
                        <?php if ( current_user_can( 'edit_theme_options' ) ) : ?>
                            <a href="<?php echo wp_customize_url(); ?>" class="load-customize hide-if-no-customize"
                               title="<?php echo esc_attr( $customize_title ); ?>">
                                <img src="<?php echo esc_url( $screenshot ); ?>"
                                     alt="<?php esc_attr_e( 'Current theme preview', 'dropout' ); ?>"/>
                            </a>
                        <?php endif; ?>
                        <img class="hide-if-customize" src="<?php echo esc_url( $screenshot ); ?>"
                             alt="<?php esc_attr_e( 'Current theme preview', 'dropout' ); ?>"/>
                    <?php endif; ?>

                    <h4><?php echo esc_html( $this->theme->display( 'Name' ) ); ?></h4>

                    <div>
                        <ul class="theme-info">
                            <li><?php printf( __( 'By %s', 'dropout' ), $this->theme->display( 'Author' ) ); ?></li>
                            <li><?php printf( __( 'Version %s', 'dropout' ), $this->theme->display( 'Version' ) ); ?></li>
                            <li><?php echo '<strong>' . __( 'Tags', 'dropout' ) . ':</strong> '; ?><?php printf( $this->theme->display( 'Tags' ) ); ?></li>
                        </ul>
                        <p class="theme-description"><?php echo esc_html( $this->theme->display( 'Description' ) ); ?></p>
                        <?php
                            if ( $this->theme->parent() ) {
                                printf( ' <p class="howto">' . __( 'This <a href="%1$s">child theme</a> requires its parent theme, %2$s.', 'dropout' ) . '</p>', __( 'http://codex.wordpress.org/Child_Themes', 'dropout' ), $this->theme->parent()->display( 'Name' ) );
                            }
                        ?>

                    </div>
                </div>

                <?php
                $item_info = ob_get_contents();

                ob_end_clean();

                $sampleHTML = '';
                if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
                    Redux_Functions::initWpFilesystem();

                    global $wp_filesystem;

                    $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
                }

                /**
                 * General Settings
                 */

                $this->sections[] = array(
                    'title'  => __( 'General Settings', 'dropout' ),
                    'desc'   => __( '', 'dropout' ),
                    'icon'   => get_template_directory_uri() . '/images/theme-options/sections/general.png',
                    'icon_type' => 'image',

                    'fields' => array(
                        array(
                            'id'       => 'gfxbucket-layout-style',
                            'type'     => 'image_select',
                            'compiler' => true,
                            'title'    => __( 'Main Layout Style', 'dropout' ),
                            'subtitle' => __( 'Select the layout style for your site. Choose a Full Width or Boxed layout.', 'dropout' ),
                            'options'  => array(
                                '1' => array(
                                    'alt' => 'Full Width',
                                    'img' => get_template_directory_uri() . '/images/theme-options/layout/full-width.png'
                                ),
                                '2' => array(
                                    'alt' => 'Boxed',
                                    'img' => get_template_directory_uri() . '/images/theme-options/layout/boxed.png'
                                ),
                            ),
                            'default'  => '1'
                        ),
                        array(
                            'id'       => 'gfxbucket-recent-post-custom-url',
                            'type'     => 'text',
                            'title'    => __( 'Recent Posts Custom URL', 'dropout' ),
                            'subtitle' => __( 'This will overwrite the post page URL for the "Read More" button.', 'dropout' ),
                            'default'  => ''
                        ),
                        array(
                            'id'       => 'gfxbucket-post-pages-type',
                            'type'     => 'select',
                            'compiler' => true,
                            'title'    => __( 'Post Pages Type', 'dropout' ),
                            'subtitle' => __( 'This will change the layout on category, tag, archive and search pages.', 'dropout' ),
                            'options'  => array(
                                '0' => __( 'Default', 'dropout' ),
                                '1' => __( 'Masonry 3 Columns', 'dropout' ),
                                '2' => __( 'Masonry 4 Columns', 'dropout' ),
                            ),
                            'default'  => '0'
                        ),
                        array(
                            'id'       => 'gfxbucket-post-sidebar',
                            'type'     => 'select',
                            'compiler' => true,
                            'title'    => __( 'Posts Default Sidebar', 'dropout' ),
                            'subtitle' => __( 'This will apply the sidebar option on all posts. The option can be changed for each post separately under the Post Options on the individual post.', 'dropout' ),
                            'options'  => array(
                                '1' => '',
                                '2' => __( 'Left sidebar', 'dropout' ),
                                '3' => __( 'Right sidebar', 'dropout' ),
                            ),
                            'default'  => '1'
                        ),
                        array(
                            'id'       => 'gfxbucket-page-sidebar',
                            'type'     => 'select',
                            'compiler' => true,
                            'title'    => __( 'Pages Default Sidebar', 'dropout' ),
                            'subtitle' => __( 'This will apply the sidebar option on all pages. The option can be changed for each page separately under the Page Options on the individual page.', 'dropout' ),
                            'options'  => array(
                                '1' => '',
                                '2' => __( 'Left sidebar', 'dropout' ),
                                '3' => __( 'Right sidebar', 'dropout' ),
                            ),
                            'default'  => '1'
                        ),
                        array(
                            'id'       => 'gfxbucket-preloader',
                            'type'     => 'switch',
                            'title'    => __( 'Progress Bar (Preloader)', 'dropout' ),
                            'subtitle' => __( 'Enable / Disable the Progress Bar on page load.', 'dropout' ),
                            'default'  => true,
                        ),
                        array(
                            'id'       => 'gfxbucket-preloader-image',
                            'type'     => 'media',
                            'preview'  => true,
                            'title'    => __( 'Progress Bar (Preloader) Image', 'dropout' ),
                            'subtitle' => __( 'Recommended image size is 50x50px or 100x100px for retina screens.', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-favicon',
                            'type'     => 'media',
                            'preview'  => true,
                            'title'    => __( 'Favicon', 'dropout' ),
                            'subtitle' => __( 'Recommended image size is 32x32px and required image formats are <strong>.ico</strong> or <strong>.png</strong>.', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-mobile-icon',
                            'type'     => 'media',
                            'preview'  => true,
                            'title'    => __( 'Mobile Icon (Home Screen Icon)', 'dropout' ),
                            'subtitle' => __( 'Recommended image size is 180x180px in PNG format. This icon will be used when users add your website as a shortcut on mobile devices like iPhone, iPad, Android etc.', 'dropout' ),
                        ),
                    ),
                );

                /**
                 * Header & Navigation
                 */

                $this->sections[] = array(
                    'title'  => __( 'Header & Navigation', 'dropout' ),
                    'desc'   => __( '', 'dropout' ),
                    'icon'   => get_template_directory_uri() . '/images/theme-options/sections/header.png',
                    'icon_type' => 'image',
                    'fields' => array(
                        array(
                            'id'       => 'gfxbucket-logo',
                            'type'     => 'media',
                            'preview'  => true,
                            'title'    => __( 'Upload Logo', 'dropout' ),
                            'subtitle' => __( 'Upload your logo image.', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-logo-light',
                            'type'     => 'media',
                            'preview'  => true,
                            'title'    => __( 'Upload Light Logo', 'dropout' ),
                            'subtitle' => __( 'Upload a light version of your logo.', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-header-style',
                            'type'     => 'image_select',
                            'compiler' => true,
                            'title'    => __( 'Header Style', 'dropout' ),
                            'subtitle' => __( '', 'dropout' ),
                            'options'  => array(
                                '1' => array(
                                    'alt' => 'Default',
                                    'img' => get_template_directory_uri() . '/images/theme-options/header-style/default.png'
                                ),
                                '2' => array(
                                    'alt' => 'Desktop',
                                    'img' => get_template_directory_uri() . '/images/theme-options/header-style/desktop.png'
                                ),
                                '3' => array(
                                    'alt' => 'Bottom',
                                    'img' => get_template_directory_uri() . '/images/theme-options/header-style/bottom.png'
                                ),
                                '4' => array(
                                    'alt' => 'Top',
                                    'img' => get_template_directory_uri() . '/images/theme-options/header-style/top.png'
                                ),
                                '5' => array(
                                    'alt' => 'Side',
                                    'img' => get_template_directory_uri() . '/images/theme-options/header-style/side.png'
                                ),
                                '6' => array(
                                    'alt' => 'Minimal',
                                    'img' => get_template_directory_uri() . '/images/theme-options/header-style/minimal.png'
                                ),
                            ),
                            'default'  => '1'
                        ),
                        array(
                            'id'       => 'gfxbucket-header-sticky',
                            'type'     => 'switch',
                            'title'    => __( 'Sticky Header', 'dropout' ),
                            'subtitle' => __( 'Enable / Disable the Sticky Header.', 'dropout' ),
                            'default'  => true,
                            'required' => array(array('gfxbucket-header-style','less','3'))
                        ),
                        array(
                            'id'       => 'gfxbucket-breadcrumbs',
                            'type'     => 'switch',
                            'title'    => __( 'Breadcrumbs', 'dropout' ),
                            'subtitle' => __( 'Breadcrumbs are a hierarchy of links displayed below the main navigation. If enabled, they will be displayed on all pages except the home-page.', 'dropout' ),
                            'default'  => false,
                        ),
                    ),
                );

                /**
                 * Footer
                 */

                $this->sections[] = array(
                    'title'  => __( 'Footer', 'dropout' ),
                    'desc'   => __( '', 'dropout' ),
                    'icon'   => get_template_directory_uri() . '/images/theme-options/sections/footer.png',
                    'icon_type' => 'image',
                    'fields' => array(
                        array(
                            'id'       => 'gfxbucket-footer-type',
                            'type'     => 'image_select',
                            'compiler' => true,
                            'title'    => __( 'Footer Type', 'dropout' ),
                            'subtitle' => __( 'Choose between modern layout, 2 columns, 3 columns or 4 columns.', 'dropout' ),
                            'options'  => array(
                                1 => array(
                                    'alt' => 'Modern',
                                    'img' => get_template_directory_uri() . '/images/theme-options/footer/modern.png'
                                ),
                                2 => array(
                                    'alt' => 'Classic 2 Columns',
                                    'img' => get_template_directory_uri() . '/images/theme-options/footer/classic-2.png'
                                ),
                                3 => array(
                                    'alt' => 'Classic 3 Columns',
                                    'img' => get_template_directory_uri() . '/images/theme-options/footer/classic-3.png'
                                ),
                                4 => array(
                                    'alt' => 'Classic 4 Columns',
                                    'img' => get_template_directory_uri() . '/images/theme-options/footer/classic-4.png'
                                ),
                            ),
                            'default'  => 1
                        ),
                        array(
                            'id'       => 'gfxbucket-footer-style',
                            'type'     => 'image_select',
                            'compiler' => true,
                            'title'    => __( 'Footer style', 'dropout' ),
                            'subtitle' => __( 'Select dark or light footer style.', 'dropout' ),
                            'options'  => array(
                                '1' => array(
                                    'alt' => 'Dark',
                                    'img' => get_template_directory_uri() . '/images/theme-options/footer/footer-dark.png'
                                ),
                                '2' => array(
                                    'alt' => 'Ligth',
                                    'img' => get_template_directory_uri() . '/images/theme-options/footer/footer-light.png'
                                ),
                            ),
                            'default'  => '1'
                        ),
                        array(
                            'id'       => 'gfxbucket-copyright-text',
                            'type'     => 'editor',
                            'title'    => __( 'Copyright Text', 'dropout' ),
                            'subtitle' => __( 'Text that is located below the main footer. Leave blank to remove it.', 'dropout' ),
                            'default'  => 'Copyright &#169; Made with Love & Caffeine by <a href="http://themeforest.net/user/gfxbucket">Gfxbucket</a>. All Rights Reserved.',
                        ),
                    ),
                );

                /**
                 * Typography
                 */

                $this->sections[] = array(
                    'title'  => __( 'Typography', 'dropout' ),
                    'desc'   => __( '', 'dropout' ),
                    'icon'   => get_template_directory_uri() . '/images/theme-options/sections/typography.png',
                    'icon_type' => 'image',
                    'fields' => array(
                        array(
                            'id'          => 'gxbucket-typography-family',
                            'type'        => 'typography',
                            'title'       => __( 'Main Font Family', 'dropout' ),
                            'subtitle'    => __( 'This effects every element on the theme. This theme was designed with only one font in mind.', 'dropout' ),
                            'google'      => true,
                            'line-height' => false,
                            'font-style'  => false,
                            'color'       => false,
                            'font-size'   => false,
                            'font-weight' => false,
                            'text-align'  => false,
                            'default'     => array(
                                'font-family'   => 'Lato',
                            ),
                        ),
                        array(
                            'id'       => 'gxbucket-typography-h1',
                            'type'     => 'spinner',
                            'title'    => __( 'H1 Size', 'dropout' ),
                            'subtitle' => __( 'Heading 1 Text Size', 'dropout' ),
                            'default'  => '36',
                            'step'     => '1',
                            'min'      => '1',
                            'max'      => '999',
                        ),
                        array(
                            'id'       => 'gxbucket-typography-h2',
                            'type'     => 'spinner',
                            'title'    => __( 'H2 Size', 'dropout' ),
                            'subtitle' => __( 'Heading 2 Text Size', 'dropout' ),
                            'default'  => '28',
                            'step'     => '1',
                            'min'      => '1',
                            'max'      => '999',
                        ),
                        array(
                            'id'       => 'gxbucket-typography-h3',
                            'type'     => 'spinner',
                            'title'    => __( 'H3 Size', 'dropout' ),
                            'subtitle' => __( 'Heading 3 Text Size', 'dropout' ),
                            'default'  => '24',
                            'step'     => '1',
                            'min'      => '1',
                            'max'      => '999',
                        ),
                        array(
                            'id'       => 'gxbucket-typography-h4',
                            'type'     => 'spinner',
                            'title'    => __( 'H4 Size', 'dropout' ),
                            'subtitle' => __( 'Heading 4 Text Size', 'dropout' ),
                            'default'  => '18',
                            'step'     => '1',
                            'min'      => '1',
                            'max'      => '999',
                        ),
                        array(
                            'id'       => 'gxbucket-typography-h5',
                            'type'     => 'spinner',
                            'title'    => __( 'H5 Size', 'dropout' ),
                            'subtitle' => __( 'Heading 5 Text Size', 'dropout' ),
                            'default'  => '16',
                            'step'     => '1',
                            'min'      => '1',
                            'max'      => '999',
                        ),
                        array(
                            'id'       => 'gxbucket-typography-h6',
                            'type'     => 'spinner',
                            'title'    => __( 'H6 Size', 'dropout' ),
                            'subtitle' => __( 'Heading 6 Text Size', 'dropout' ),
                            'default'  => '14',
                            'step'     => '1',
                            'min'      => '1',
                            'max'      => '999',
                        ),
                    ),
                );

                /**
                 * Styling
                 */

                $this->sections[] = array(
                    'title'  => __( 'Styling', 'dropout' ),
                    'desc'   => __( '', 'dropout' ),
                    'icon'   => get_template_directory_uri() . '/images/theme-options/sections/styling.png',
                    'icon_type' => 'image',
                    'fields' => array(
                        array(
                            'id'          => 'gfxbucket-style-color-main',
                            'type'        => 'color',
                            'title'       => __( 'Main Theme Color', 'dropout' ),
                            'default'     => '#1FD7D2',
                            'transparent' => 'false',
                            'validate'    => 'color',
                        ),
                        array(
                            'id'          => 'gfxbucket-style-color-text',
                            'type'        => 'color',
                            'title'       => __( 'Text Color', 'dropout' ),
                            'default'     => '#777777',
                            'transparent' => 'false',
                            'validate'    => 'color',
                        ),
                        array(
                            'id'          => 'gfxbucket-style-color-heading',
                            'type'        => 'color',
                            'title'       => __( 'Heading Color', 'dropout' ),
                            'default'     => '#222222',
                            'transparent' => 'false',
                            'validate'    => 'color',
                        ),
                        array(
                            'id'       => 'gfxbucket-style-background',
                            'type'     => 'background',
                            'output'   => array( 'body' ),
                            'transparent' => 'false',
                            'title'    => __( 'Site Background', 'dropout' ),
                            'subtitle' => __( 'For Boxed layout only.', 'dropout' ),
                        ),
                    ),
                );

                /**
                 * Social Media
                 */

                $this->sections[] = array(
                    'title'  => __( 'Social Media', 'dropout' ),
                    'desc'   => __( '', 'dropout' ),
                    'icon'   => get_template_directory_uri() . '/images/theme-options/sections/social.png',
                    'icon_type' => 'image',
                    'fields' => array(
                        array(
                            'id'       => 'gfxbucket-social-status',
                            'type'     => 'switch',
                            'title'    => __( 'Show Header Social Media Icons', 'dropout' ),
                            'subtitle' => __( 'Enable / Disable the Social Media Icons in the Header.', 'dropout' ),
                            'default'  => true,
                        ),
                        array(
                            'id'       => 'gfxbucket-portfolio-social-status',
                            'type'     => 'switch',
                            'title'    => __( 'Show Share Icons On Portfolio Posts', 'dropout' ),
                            'subtitle' => __( 'Enable / Disable the Social Media Share Icons on Portfolio posts.', 'dropout' ),
                            'default'  => true,
                        ),
                        array(
                            'id'       => 'gfxbucket-social-facebook',
                            'type'     => 'text',
                            'title'    => __( 'Facebook', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-twitter',
                            'type'     => 'text',
                            'title'    => __( 'Twitter', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-google-plus',
                            'type'     => 'text',
                            'title'    => __( 'Google+', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-linkedin',
                            'type'     => 'text',
                            'title'    => __( 'LinkedIn', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-dribbble',
                            'type'     => 'text',
                            'title'    => __( 'Dribbble', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-behance',
                            'type'     => 'text',
                            'title'    => __( 'Behance', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-tumblr',
                            'type'     => 'text',
                            'title'    => __( 'Tumblr', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-instagram',
                            'type'     => 'text',
                            'title'    => __( 'Instagram', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-pinterest',
                            'type'     => 'text',
                            'title'    => __( 'Pinterest', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-youtube',
                            'type'     => 'text',
                            'title'    => __( 'YouTube', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-vimeo-square',
                            'type'     => 'text',
                            'title'    => __( 'Vimeo', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-github',
                            'type'     => 'text',
                            'title'    => __( 'Github', 'dropout' ),
                        ),
                        array(
                            'id'       => 'gfxbucket-social-custom',
                            'type'     => 'repeater',
                            'title'    => __( 'Other Icons', 'dropout' ),
                        ),
                    ),
                );

                /**
                 * Custom Code
                 */

                $this->sections[] = array(
                    'title'  => __( 'Custom Code', 'dropout' ),
                    'desc'   => __( '', 'dropout' ),
                    'icon'   => get_template_directory_uri() . '/images/theme-options/sections/custom-code.png',
                    'icon_type' => 'image',
                    'fields' => array(
                        array(
                            'id'       => 'gfxbucket-custom-css-code',
                            'type'     => 'ace_editor',
                            'title'    => __( 'Custom CSS Code', 'dropout' ),
                            'subtitle' => __( 'Enter your CSS code here.', 'dropout' ),
                            'mode'     => 'css',
                            'theme'    => 'chrome',
                            'default'  => ''
                        ),
                        array(
                            'id'       => 'gfxbucket-custom-js',
                            'type'     => 'ace_editor',
                            'title'    => __( 'Custom JavaScript Code', 'dropout' ),
                            'subtitle' => __( 'Enter your JavaScript code here.', 'dropout' ),
                            'mode'     => 'javascript',
                            'theme'    => 'chrome',
                            'default'  => ''
                        ),
                    ),
                );


                /**
                 * Dummy Content
                 */

                $this->sections[] = array(
                    'title'  => __( 'Demo Importer', 'dropout' ),
                    'desc'   => __( '', 'dropout' ),
                    'icon'   => get_template_directory_uri() . '/images/theme-options/sections/demo-import.png',
                    'icon_type' => 'image',
                    'fields' => array(
                        array(
                            'id'       => 'gfxbucket-custom-css-code',
                            'type'     => 'demo_import',
                            'title'    => __( 'Import Demo Content', 'dropout' ),
                            'subtitle' => __( 'Select a demo you wish to import. Please install all recommended plugins before importing our demo content. We recommend importing demo content on fresh WordPress sites. If you already have content on your site, please create a backup before continuing.', 'dropout' ),
                            'mode'     => 'css',
                            'theme'    => 'chrome',
                            'default'  => ''
                        ),
                    ),
                );

                if ( file_exists( trailingslashit( dirname( __FILE__ ) ) . 'README.html' ) ) {
                    $tabs['docs'] = array(
                        'icon'    => 'el-icon-book',
                        'title'   => __( 'Documentation', 'dropout' ),
                        'content' => nl2br( file_get_contents( trailingslashit( dirname( __FILE__ ) ) . 'README.html' ) )
                    );
                }
            }

            public function setHelpTabs() {

                // Custom page help tabs, displayed using the help API. Tabs are shown in order of definition.
                $this->args['help_tabs'][] = array(
                    'id'      => 'redux-help-tab-1',
                    'title'   => __( 'Theme Information 1', 'dropout' ),
                    'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'dropout' )
                );

                $this->args['help_tabs'][] = array(
                    'id'      => 'redux-help-tab-2',
                    'title'   => __( 'Theme Information 2', 'dropout' ),
                    'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'dropout' )
                );

                // Set the help sidebar
                $this->args['help_sidebar'] = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'dropout' );
            }

            /**
             * All the possible arguments for Redux.
             * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
             * */
            public function setArguments() {

                $theme = wp_get_theme(); // For use with some settings. Not necessary.

                $this->args = array(
                    // General Settings
                    'opt_name'             => 'gfxbucket_options',
                    'display_name'         => $theme->get( 'Name' ) . ' ' . __( 'Options', 'dropout' ),
                    'display_version'      => $theme->get( 'Version' ),
                    'menu_type'            => 'submenu',
                    'menu_title'           => __( 'Theme Options', 'dropout' ),
                    'page_title'           => __( 'Theme Options', 'dropout' ),
                    // You will need to generate a Google API key to use this feature.
                    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
                    'google_api_key'       => '',
                    // Set it you want google fonts to update weekly. A google_api_key value is required.
                    'google_update_weekly' => false,
                    // Must be defined to add google fonts to the typography module
                    'async_typography'     => true,
                    'admin_bar'            => false,
                    'global_variable'      => 'gfxbucket_options',
                    'dev_mode'             => false,
                    'customizer'           => true,

                    // Extra Settings
                    'page_parent'          => 'themes.php',
                    'page_permissions'     => 'manage_options',
                    'last_tab'             => '',
                    'page_slug'            => 'gfxbucket_options',
                    'save_defaults'        => true,
                    'default_show'         => false,
                    'show_import_export'   => false,

                    // Hints
                    'hints'                => array(
                        'icon'          => 'icon-question-sign',
                        'icon_position' => 'right',
                        'icon_color'    => 'lightgray',
                        'icon_size'     => 'normal',
                        'tip_style'     => array(
                            'color'   => 'light',
                            'shadow'  => true,
                            'rounded' => false,
                            'style'   => '',
                        ),
                        'tip_position'  => array(
                            'my' => 'top left',
                            'at' => 'bottom right',
                        ),
                        'tip_effect'    => array(
                            'show' => array(
                                'effect'   => 'slide',
                                'duration' => '500',
                                'event'    => 'mouseover',
                            ),
                            'hide' => array(
                                'effect'   => 'slide',
                                'duration' => '500',
                                'event'    => 'click mouseleave',
                            ),
                        ),
                    )
                );

                // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
                $this->args['admin_bar_links'][] = array(
                    'id'    => 'redux-docs',
                    'href'   => 'http://docs.reduxframework.com/',
                    'title' => __( 'Documentation', 'dropout' ),
                );

                $this->args['admin_bar_links'][] = array(
                    //'id'    => 'redux-support',
                    'href'   => 'https://github.com/ReduxFramework/redux-framework/issues',
                    'title' => __( 'Support', 'dropout' ),
                );

                $this->args['admin_bar_links'][] = array(
                    'id'    => 'redux-extensions',
                    'href'   => 'reduxframework.com/extensions',
                    'title' => __( 'Extensions', 'dropout' ),
                );
            }
        }

        global $reduxConfig;
        $reduxConfig = new Gfxbucket_Framework_config();
    }
