<?php

class Gfxbucket_Social extends WP_Widget {

	/**
	 * Sets up the widgets name etc
	 */
	function __construct() {
		parent::__construct(
			'gfxbucket_social', // Base ID
			__( 'Gfxbucket Social', 'dropout' ), // Name
			array( 'description' => __( 'Show social icons, set in the Theme Options', 'dropout' ), ) // Args
		);
	}

	/**
	 * Outputs the content of the widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
		$wp_kses_attr_widget = array(
			'div' => array(
				'id' => array(),
				'class' => array(),
			),
		);

		$wp_kses_attr_title = array(
			'h4' => array(
				'class' => array(),
			),
		);

		echo wp_kses( $args['before_widget'], $wp_kses_attr_widget);

		if ( ! empty( $instance['title'] ) ) {
			echo wp_kses( $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'], $wp_kses_attr_title );
		}

		$socials = array('facebook', 'twitter', 'google-plus', 'linkedin', 'dribbble', 'behance', 'tumblr', 'instagram', 'pinterest', 'youtube', 'vimeo-square', 'github');

		global $gfxbucket_options;

		$return = '';

		foreach( $socials as $social ) {
			if( isset($gfxbucket_options['gfxbucket-social-' . $social]) && $gfxbucket_options['gfxbucket-social-' . $social] != '' ) {
				$return .= '<li><a href="' . $gfxbucket_options['gfxbucket-social-' . $social] . '" target="_blank" rel="nofollow"><i class="fa fa-' . $social . '"></i></a></li>';
			}
		}

		if( isset($gfxbucket_options['gfxbucket-social-custom']) && $gfxbucket_options['gfxbucket-social-custom'] ) {
			$custom_icons = explode('|', $gfxbucket_options['gfxbucket-social-custom']);

			foreach ($custom_icons as $icon) {
				$icon = explode(';', $icon);
				$icon_val = $icon[0];
                $icon_url = $icon[1];

				$return .= '<li><a href="' . $icon_url . '" target="_blank" rel="nofollow"><i class="fa ' . $icon_val . '"></i></a></li>';
			}
		}

		echo '<ul class="social">' . $return . '<li><a href="https://twitter.com/@Contractnews" target="_blank" rel="nofollow"><i class="fa fa-twitter"></i></a></li></ul>';

		echo wp_kses( $args['after_widget'], $wp_kses_attr_widget);
	}

	/**
	 * Outputs the options form on admin
	 *
	 * @param array $instance The widget options
	 */
	public function form( $instance ) {
		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title', 'dropout' ); ?>:</label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>

		<p><?php _e( 'Social icon links can be set under Theme Options.', 'dropout' ); ?></p>
		<?php
	}

	/**
	 * Processing widget options on save
	 *
	 * @param array $new_instance The new options
	 * @param array $old_instance The previous options
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

		return $instance;
	}
}
