<?php get_header();

global $gfxbucket_options;

$layout = 0;

if( isset($gfxbucket_options['gfxbucket-post-pages-type']) ) {
	$layout = $gfxbucket_options['gfxbucket-post-pages-type'];
}

$row_class = 'row blog-wrapper';
$wrapper_class = 'col-md-8 col-md-offset-2';
$masonry_type = 'masonry-3-columns';

if( $layout != 0 ) {
	$row_class .= ' blog-masonry';
	$wrapper_class = 'col-md-12';
}

if( $layout == 2 ) {
	$masonry_type = 'masonry-4-columns';
}
?>

<div class="container">
	
	<h1>Resultados de búsqueda</h1>

	<main id="main" class="site-main <?php echo $wrapper_class; ?>" role="main">
		<?php if ( have_posts() ) : ?>
			<div class="<?php echo $row_class; ?>">
				<?php
					while ( have_posts() ) { the_post();
						if( $layout == 0 ) {
							//get_template_part( 'content', get_post_format() );
							
							echo "<h2>"; 
							the_title();
							echo "</h2>";

							$link = get_the_permalink();

							echo '<p>';
							the_excerpt();
							echo '</p>';

							echo '<a class="verLink" href="'.$link.'">Ver</a>';


						} else {
							$ids[] = $post->ID;
						}
					}

					if( $layout != 0 ) {
						echo do_shortcode('[blog pagination="off" per_page="' . get_option('posts_per_page') . '" ids="' . implode(',', $ids) . '" wrapper="off" type="'. $masonry_type . '"]');
					}
				?>
			</div>
			<div class="row">
			<?php
				$args = array(
					'type'      => 'list',
					'next_text' => '<i class="fa fa-angle-right"></i>',
					'prev_text' => '<i class="fa fa-angle-left"></i>',
					'current'   => (get_query_var('paged')) ? get_query_var('paged') : 1,
				);

				echo '<nav class="page-nav">' . paginate_links( $args ) . '</nav>';

				wp_reset_postdata();
			?>
			</div>
		<?php else : ?>
			<div class="search-error">
				<h2 class="search-error-title"><?php _e( 'Lo sentimos, no hay resultados para su búsqueda', 'dropout' ); ?></h2>
				<div class="widget_search" style="margin-bottom:60px"><?php get_search_form(); ?></div>
			</div>
		<?php endif; ?>
	</main>
</div>
	
<?php get_footer(); ?>