(function() {
    tinymce.PluginManager.add('gfxbucket_tc_shortcodes', function( editor, url ) {
        editor.addButton( 'gfxbucket_tc_shortcodes', {
            text: 'Shortcodes',
            title: 'Add Shortcodes',
            type: 'menubutton',
            menu: [

                /* Break */
                {
                    text: 'Break',
                    onclick: function() {
                        editor.insertContent( '[break /]');
                    }
                },
                /* /Break */

                /* Button */
                {
                    text: 'Button',
                    onclick: function() {
                        editor.windowManager.open( {
                            title: 'Insert Button Shortcode',
                            body: [{
                                type: 'textbox',
                                name: 'text',
                                label: 'Text',
                                minWidth: '300'
                            },
                            {
                                type: 'listbox',
                                name: 'size',
                                label: 'Size',
                                'values': [
                                    {text: 'Small', value: 'small'},
                                    {text: 'Medium', value: 'medium'},
                                    {text: 'Large', value: 'large'},
                                ]
                            },
                            {
                                type: 'textbox',
                                name: 'url',
                                label: 'URL'
                            },
                            {
                                type: 'checkbox',
                                name: 'new_window',
                                label: 'Open in a new window'
                            }],
                            onsubmit: function( e ) {
                                editor.insertContent( '[button url="' + e.data.url + '" new_window="' + e.data.new_window + '" size="' + e.data.size + '"]' + e.data.text + '[/button]');
                            }
                        });
                    }
                },
                /* /Button */

                /* Clients */
                {
                    text: 'Clients',
                    onclick: function() {
                        editor.windowManager.open( {
                            title: 'Insert Clients Shortcode',
                            body: [                            {
                                type: 'listbox',
                                name: 'num_clients',
                                label: 'Number Of Clients',
                                'values': [
                                    {text: '1', value: 1},
                                    {text: '2', value: 2},
                                    {text: '3', value: 3},
                                    {text: '4', value: 4},
                                    {text: '5', value: 5},
                                    {text: '6', value: 6},
                                    {text: '7', value: 7},
                                    {text: '8', value: 8},
                                    {text: '9', value: 9},
                                    {text: '10', value: 10},
                                    {text: '11', value: 11},
                                    {text: '12', value: 12},
                                ]
                            },],
                            onsubmit: function( e ) {
                                var clients = '<br />';
                                for(var i=0; i<e.data.num_clients; i++) {
                                    clients += '[client image="" title="" url="#" new_tab="yes" /]<br />';
                                }

                                editor.insertContent( '[clients]' + clients + '[/clients]');
                            }
                        });
                    }
                },
                /* /Clients */

                /* Counter */
                {
                    text: 'Counter',
                    onclick: function() {
                        editor.windowManager.open( {
                            title: 'Insert Counter Shortcode',
                            body: [                            {
                                type: 'listbox',
                                name: 'num_counter_items',
                                label: 'Number Of Counter Items',
                                'values': [
                                    {text: '1', value: 1},
                                    {text: '2', value: 2},
                                    {text: '3', value: 3},
                                    {text: '4', value: 4},
                                    {text: '5', value: 5},
                                    {text: '6', value: 6},
                                ]
                            },
                            {
                                type: 'listbox',
                                name: 'animate',
                                label: 'Animate',
                                'values': [
                                    {text: 'Yes', value: 'yes'},
                                    {text: 'No', value: 'no'},
                                ]
                            }],
                            onsubmit: function( e ) {
                                var counterItems = '<br />';
                                for(var i=0; i<e.data.num_counter_items; i++) {
                                    counterItems += '[counter_item title="" number="" /]<br />';
                                }

                                editor.insertContent( '[counter animate="' + e.data.animate + '"]' + counterItems + '[/counter]');
                            }
                        });
                    }
                },
                /* /Counter */

                /* Instagram */
                {
                    text: 'Instagram',
                    onclick: function() {
                        editor.windowManager.open( {
                            title: 'Insert Instagram Shortcode',
                            body: [{
                                type: 'textbox',
                                name: 'id',
                                label: 'Instagram User ID',
                                minWidth: '300'
                            }],
                            onsubmit: function( e ) {
                                editor.insertContent( '[instagram]' + e.data.id + '[/instagram]');
                            }
                        });
                    }
                },
                /* /Instagram */

                /* Pricing Table */
                {
                    text: 'Pricing Table',
                    onclick: function() {
                        editor.windowManager.open( {
                            title: 'Insert Pricing Table Shortcode',
                            body: [{
                                type: 'textbox',
                                name: 'title',
                                label: 'Title',
                                minWidth: '300'
                            },
                            {
                                type: 'textbox',
                                name: 'price',
                                label: 'Price',
                                minWidth: '300'
                            },
                            {
                                type: 'textbox',
                                name: 'currency',
                                label: 'Currency',
                                minWidth: '300'
                            },
                            {
                                type: 'listbox',
                                name: 'currency_position',
                                label: 'Size',
                                'values': [
                                    {text: 'Left', value: 'left'},
                                    {text: 'Right', value: 'right'},
                                ]
                            },
                            {
                                type: 'textbox',
                                name: 'link',
                                label: 'Link',
                                minWidth: '300'
                            },
                            {
                                type: 'textbox',
                                name: 'link_text',
                                label: 'Link Text',
                                minWidth: '300'
                            },
                            {
                                type: 'listbox',
                                name: 'num_rows',
                                label: 'Number Of Table Rows',
                                'values': [
                                    {text: '1', value: 1},
                                    {text: '2', value: 2},
                                    {text: '3', value: 3},
                                    {text: '4', value: 4},
                                    {text: '5', value: 5},
                                    {text: '6', value: 6},
                                    {text: '7', value: 7},
                                    {text: '8', value: 8},
                                    {text: '9', value: 9},
                                    {text: '10', value: 10},
                                ]
                            },],
                            onsubmit: function( e ) {
                                var tableRows = '<br />';
                                for(var i=0; i<e.data.num_rows; i++) {
                                    tableRows += '[pricing_table_row][/pricing_table_row]<br />';
                                }

                                editor.insertContent( '[pricing_table title="' + e.data.title + '" price="' + e.data.price + '" currency="' + e.data.currency + '" currency_position="' + e.data.currency_position + '" link="' + e.data.link + '" link_text="' + e.data.link_text + '"]' + tableRows + '[/pricing_table]');
                            }
                        });
                    }
                },
                /* /Pricing Table */

                /* Progress Bar */
                {
                    text: 'Progress Bar',
                    onclick: function() {
                        editor.windowManager.open( {
                            title: 'Insert Progress Bar Shortcode',
                            body: [{
                                type: 'textbox',
                                name: 'title',
                                label: 'Title',
                                minWidth: '300'
                            },
                            {
                                type: 'textbox',
                                name: 'subtitle',
                                label: 'Subtitle',
                                minWidth: '300'
                            },
                            {
                                type: 'textbox',
                                name: 'percentage',
                                label: 'Percentage',
                                minWidth: '300'
                            }],
                            onsubmit: function( e ) {
                                editor.insertContent( '[progress_bar title="' + e.data.title + '" subtitle="' + e.data.subtitle + '"]' + e.data.percentage + '[/progress_bar]');
                            }
                        });
                    }
                },
                /* /Progress Bar */

                /* Recent Posts */
                {
                    text: 'Recent Posts',
                    onclick: function() {
                        editor.windowManager.open( {
                            title: 'Insert Recent Posts Shortcode',
                            body: [{
                                type: 'textbox',
                                name: 'num_posts',
                                label: 'Number Of Posts',
                                minWidth: '300'
                            },
                            {
                                type: 'listbox',
                                name: 'show_more_button',
                                label: 'Show More Button',
                                'values': [
                                    {text: 'No', value: 'no'},
                                    {text: 'Yes', value: 'yes'},
                                ]
                            },],
                            onsubmit: function( e ) {
                                editor.insertContent( '[recent_posts show_more_button="' + e.data.show_more_button + '"]' + e.data.num_posts + '[/recent_posts]' );
                            }
                        });
                    }
                },
                /* /Recent Posts */

                /* Title */
                {
                    text: 'Title',
                    onclick: function() {
                        editor.windowManager.open( {
                            title: 'Insert Title Shortcode',
                            body: [{
                                type: 'textbox',
                                name: 'text',
                                label: 'Text',
                                minWidth: '300'
                            },
                            {
                                type: 'listbox',
                                name: 'size',
                                label: 'Size',
                                'values': [
                                    {text: 'H2 (48px)', value: 'h2'},
                                    {text: 'H1 (60px)', value: 'h1'},
                                    {text: 'H3 (32px)', value: 'h3'},
                                    {text: 'H4 (26px)', value: 'h4'},
                                    {text: 'H5 (21px)', value: 'h5'},
                                    {text: 'H6 (18px)', value: 'h6'},
                                ]
                            },],
                            onsubmit: function( e ) {
                                editor.insertContent( '[title]' + e.data.text + '[/title]');
                            }
                        });
                    }
                },
                /* /Title */

            ]
        });
    });
})();