<?php

function testimonials_func( $atts, $content ) {
	extract(shortcode_atts( array(), $atts ));

	wp_enqueue_script( 'slick', plugins_url( 'javascript/slick.min.js', __FILE__ ), array('jquery'), '', true );

	return '<div class="testimonials">' . do_shortcode($content) . '</div>';
}
add_shortcode( 'testimonials', 'testimonials_func' );

global $gfxbucket_first;
$gfxbucket_first = true;

function testimonials_item_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'name'       => '',
		'title'      => '',
		'image'      => '',
		'rating'     => '0',
		'text'       => '',
		'link'       => '#',
		'link_text'  => __( 'Watch video', 'gfxbucket-shortcodes' ),
		'new_window' => 'false'
	), $atts ));

	global $gfxbucket_first;

	$class = 'review-content col-md-6';
	$stars = '';
	$prepend = '';
	$append = '';

	// Rating
	for($i=0;$i<$rating;$i++) {
		$stars .= '<i class="fa fa-star-o"></i>';
	}

	// New Window
	$target = '';
	if( $new_window == 'true' ) {
		$target = ' target="_blank"';
	}

	// Check 1st/2nd
	if( $gfxbucket_first ) {
		$class .= ' col-md-offset-6';
		$gfxbucket_first = false;
		$prepend = '<div class="row">';
	} else {
		$gfxbucket_first = true;
		$append = '</div>';
	}

	// Return
	return $prepend . '<article class="review col-md-6">
		<img class="review-image" src="' . $image . '" alt="' . $name . '">
		<div class="' . $class . '">
			<h5>' . $name . '</h5>
			<span class="review-subtitle">' . $title . '</span>
			<div class="review-rating">' . $stars . '</div>
			<p>' . $text . '</p>
			<a href="' . $link . '" class="more"' . $target . '>' . $link_text . '</a>
		</div>
	</article>' . $append;
}
add_shortcode( 'testimonials_item', 'testimonials_item_func' );