<?php
/* Set global counter for unique IDs */
global $gfxbucket_twitter;
$gfxbucket_twitter = 0;

function gfxbucket_twitter_func( $atts, $content ) {
	extract(shortcode_atts( array(
		'fs'      => 'off',
	), $atts ));

	global $gfxbucket_twitter;
	$gfxbucket_twitter++;

	if( !$content ) {
		$content = 'envato';
	}

	wp_enqueue_script( 'gfxbucket-tweet', plugins_url( 'javascript/jquery.tweet.min.js', __FILE__ ), array('jquery'), '', true );

	ob_start();
	?>
	
	<div id="twitter-<?php echo $gfxbucket_twitter; ?>" class="twitter statement">
		<?php if( $fs == 'off' ): ?>
		<div class="twitter-cover-photo parallax"></div>
		<div class="container">
			<div class="row">
		<?php else: ?>
			<div class="twitter-cover-photo"></div>
		<?php endif; ?>
				<div class="col-md-12">
					<div class="twitter-author-photo"></div>
					<div class="twitter-feed"></div>
					<ul class="twitter-meta">
						<li class="num-tweets">
							<span></span>
							<strong><?php _e( 'Tweets', 'gfxbucket-shortcodes' ); ?></strong>
						</li>
						<li class="num-followers">
							<span></span>
							<strong><?php _e( 'Followers', 'gfxbucket-shortcodes' ); ?></strong>
						</li>
						<li class="num-likes">
							<span></span>
							<strong><?php _e( 'Following', 'gfxbucket-shortcodes' ); ?></strong>
						</li>
					</ul>
					<a target="_blank" href="https://twitter.com/<?php echo $content ; ?>" class="btn btn-lg twitter-follow"><?php _e( 'Follow us', 'gfxbucket-shortcodes' ); ?></a>
				</div>
			<?php if( $fs == 'off' ): ?>
			</div>
		</div>
		<?php endif; ?>
	</div>

  	<script type="text/javascript">
		jQuery(document).ready(function($) {
			$('#twitter-<?php echo $gfxbucket_twitter; ?> .twitter-feed').tweet({
				username: '<?php echo $content; ?>',
			    modpath: '<?php echo plugins_url( 'twitter/', __FILE__ ); ?>',
			    loading_text: <?php _e( "'loading twitter feed...'", 'gfxbucket-shortcodes' ); ?>,
			});
		});
	</script>

	<?php
	$return = ob_get_contents();
	ob_end_clean();

	return $return;
}
add_shortcode( 'twitter', 'gfxbucket_twitter_func' );